/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.io.Serializable;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;

public abstract class LifecycleMessage
extends EhcacheOperationMessage
implements Serializable {

    public static class PrepareForDestroy
    extends LifecycleMessage {
        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.PREPARE_FOR_DESTROY;
        }
    }

    public static class ValidateServerStore
    extends LifecycleMessage {
        private final String name;
        private final ServerStoreConfiguration storeConfiguration;

        ValidateServerStore(String name, ServerStoreConfiguration storeConfiguration) {
            this.name = name;
            this.storeConfiguration = storeConfiguration;
        }

        public String getName() {
            return this.name;
        }

        public ServerStoreConfiguration getStoreConfiguration() {
            return this.storeConfiguration;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.VALIDATE_SERVER_STORE;
        }
    }

    public static class ValidateStoreManager
    extends LifecycleMessage {
        private final ServerSideConfiguration configuration;

        ValidateStoreManager(ServerSideConfiguration config) {
            this.configuration = config;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.VALIDATE;
        }

        public ServerSideConfiguration getConfiguration() {
            return this.configuration;
        }
    }
}

