/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease.connection;

import com.tc.util.ManagedServiceLoader;
import java.net.URI;
import java.util.Collection;
import java.util.Properties;
import org.terracotta.connection.ConnectionException;
import org.terracotta.lease.connection.LeasedConnection;
import org.terracotta.lease.connection.LeasedConnectionService;

public class LeasedConnectionFactory {
    public static LeasedConnection connect(URI uri, Properties properties) throws ConnectionException {
        Collection<LeasedConnectionService> serviceLoaders = ManagedServiceLoader.loadServices(LeasedConnectionService.class, LeasedConnectionService.class.getClassLoader());
        for (LeasedConnectionService connectionService : serviceLoaders) {
            if (!connectionService.handlesURI(uri)) continue;
            return connectionService.connect(uri, properties);
        }
        throw new IllegalArgumentException("Unknown URI " + uri);
    }
}

