/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.decoding;

import org.terracotta.runnel.decoding.fields.ValueField;
import org.terracotta.runnel.utils.ReadBuffer;

public class ArrayDecoder<T, P> {
    private final ValueField<T> arrayedField;
    private final ReadBuffer readBuffer;
    private final P parent;
    private final int length;

    public ArrayDecoder(ValueField<T> arrayedField, ReadBuffer readBuffer, P parent) {
        this.arrayedField = arrayedField;
        this.parent = parent;
        int size = readBuffer.getVlqInt();
        this.readBuffer = readBuffer.limit(size);
        this.length = readBuffer.getVlqInt();
    }

    public int length() {
        return this.length;
    }

    public T value() {
        return this.arrayedField.decode(this.readBuffer);
    }

    public P end() {
        this.readBuffer.skipAll();
        return this.parent;
    }
}

