/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.service;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.ehcache.CachePersistenceException;
import org.ehcache.clustered.client.config.ClusteredResourcePool;
import org.ehcache.clustered.client.config.ClusteredResourceType;
import org.ehcache.clustered.client.config.ClusteringServiceConfiguration;
import org.ehcache.clustered.client.config.Timeouts;
import org.ehcache.clustered.client.internal.ClusterTierManagerClientEntity;
import org.ehcache.clustered.client.internal.ClusterTierManagerClientEntityFactory;
import org.ehcache.clustered.client.internal.ClusterTierManagerCreationException;
import org.ehcache.clustered.client.internal.ClusterTierManagerValidationException;
import org.ehcache.clustered.client.internal.service.AbstractClientEntityFactory;
import org.ehcache.clustered.client.internal.service.ClusterStateRepository;
import org.ehcache.clustered.client.internal.service.ClusterTierException;
import org.ehcache.clustered.client.internal.store.ClusterTierClientEntity;
import org.ehcache.clustered.client.internal.store.EventualServerStoreProxy;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.StrongServerStoreProxy;
import org.ehcache.clustered.client.service.ClientEntityFactory;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.clustered.client.service.EntityBusyException;
import org.ehcache.clustered.client.service.EntityService;
import org.ehcache.clustered.common.Consistency;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.exceptions.DestroyInProgressException;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourceType;
import org.ehcache.core.spi.store.Store;
import org.ehcache.spi.persistence.PersistableResourceService;
import org.ehcache.spi.persistence.StateRepository;
import org.ehcache.spi.service.MaintainableService;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.entity.Entity;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.lease.connection.LeasedConnectionFactory;

class DefaultClusteringService
implements ClusteringService,
EntityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClusteringService.class);
    static final String CONNECTION_PREFIX = "Ehcache:";
    private final ClusteringServiceConfiguration configuration;
    private final URI clusterUri;
    private final String entityIdentifier;
    private final ConcurrentMap<String, ClusteredSpace> knownPersistenceSpaces = new ConcurrentHashMap<String, ClusteredSpace>();
    private final Timeouts timeouts;
    private final Properties properties;
    private volatile Connection clusterConnection;
    private ClusterTierManagerClientEntityFactory entityFactory;
    private ClusterTierManagerClientEntity entity;
    private final ConcurrentMap<String, ClusterTierClientEntity> clusterTierEntities = new ConcurrentHashMap<String, ClusterTierClientEntity>();
    private volatile boolean inMaintenance = false;

    DefaultClusteringService(ClusteringServiceConfiguration configuration) {
        this.configuration = configuration;
        URI ehcacheUri = configuration.getClusterUri();
        this.clusterUri = DefaultClusteringService.extractClusterUri(ehcacheUri);
        this.entityIdentifier = this.clusterUri.relativize(ehcacheUri).getPath();
        this.timeouts = configuration.getTimeouts();
        this.properties = configuration.getProperties();
    }

    private static URI extractClusterUri(URI uri) {
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public ClusteringServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public <E extends Entity, C> ClientEntityFactory<E, C> newClientEntityFactory(String entityIdentifier, Class<E> entityType, long entityVersion, C configuration) {
        return new AbstractClientEntityFactory<E, C, Void>(entityIdentifier, entityType, entityVersion, configuration){

            @Override
            protected Connection getConnection() {
                if (!DefaultClusteringService.this.isConnected()) {
                    throw new IllegalStateException(this.getClass().getSimpleName() + " not started.");
                }
                return DefaultClusteringService.this.clusterConnection;
            }
        };
    }

    @Override
    public boolean isConnected() {
        return this.clusterConnection != null;
    }

    public void start(ServiceProvider<Service> serviceProvider) {
        block6: {
            this.initClusterConnection();
            this.createEntityFactory();
            try {
                if (this.configuration.isAutoCreate()) {
                    this.entity = this.autoCreateEntity();
                    break block6;
                }
                try {
                    this.entity = this.entityFactory.retrieve(this.entityIdentifier, this.configuration.getServerConfiguration());
                }
                catch (DestroyInProgressException | EntityNotFoundException e) {
                    throw new IllegalStateException("The cluster tier manager '" + this.entityIdentifier + "' does not exist. Please review your configuration.", e);
                }
                catch (TimeoutException e) {
                    throw new RuntimeException("Could not connect to the cluster tier manager '" + this.entityIdentifier + "'; retrieve operation timed out", e);
                }
            }
            catch (RuntimeException e) {
                this.entityFactory = null;
                this.closeConnection();
                throw e;
            }
        }
    }

    public void startForMaintenance(ServiceProvider<? super MaintainableService> serviceProvider, MaintainableService.MaintenanceScope maintenanceScope) {
        this.initClusterConnection();
        this.createEntityFactory();
        if (maintenanceScope == MaintainableService.MaintenanceScope.CACHE_MANAGER && !this.entityFactory.acquireLeadership(this.entityIdentifier)) {
            this.entityFactory = null;
            this.closeConnection();
            throw new IllegalStateException("Couldn't acquire cluster-wide maintenance lease");
        }
        this.inMaintenance = true;
    }

    private void createEntityFactory() {
        this.entityFactory = new ClusterTierManagerClientEntityFactory(this.clusterConnection, this.timeouts);
    }

    private void initClusterConnection() {
        try {
            this.properties.put("connection.name", CONNECTION_PREFIX + this.entityIdentifier);
            this.properties.put("connection.timeout", Long.toString(this.timeouts.getConnectionTimeout().toMillis()));
            this.clusterConnection = LeasedConnectionFactory.connect(this.clusterUri, this.properties);
        }
        catch (ConnectionException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Loose catch block
     */
    private ClusterTierManagerClientEntity autoCreateEntity() throws ClusterTierManagerValidationException, IllegalStateException {
        while (true) {
            try {
                this.entityFactory.create(this.entityIdentifier, this.configuration.getServerConfiguration());
            }
            catch (ClusterTierManagerCreationException e) {
                throw new IllegalStateException("Could not create the cluster tier manager '" + this.entityIdentifier + "'.", e);
            }
            catch (EntityBusyException | EntityAlreadyExistsException e) {
                // empty catch block
            }
            try {
                return this.entityFactory.retrieve(this.entityIdentifier, this.configuration.getServerConfiguration());
            }
            catch (DestroyInProgressException e) {
                this.silentDestroy();
                continue;
            }
            catch (EntityNotFoundException e) {
                continue;
            }
            break;
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Could not connect to the cluster tier manager '" + this.entityIdentifier + "'; retrieve operation timed out", e);
        }
    }

    private void silentDestroy() {
        LOGGER.debug("Found a broken ClusterTierManager - trying to clean it up");
        try {
            Thread.sleep(new Random().nextInt(1000));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        try {
            this.entityFactory.destroy(this.entityIdentifier);
        }
        catch (EntityBusyException e) {
            LOGGER.debug("ClusterTierManager {} marked busy when trying to clean it up", (Object)this.entityIdentifier);
        }
    }

    public void stop() {
        LOGGER.info("Closing connection to cluster {}", (Object)this.clusterUri);
        this.entityFactory = null;
        this.inMaintenance = false;
        this.clusterTierEntities.clear();
        this.entity = null;
        this.closeConnection();
    }

    public void destroyAll() throws CachePersistenceException {
        if (!this.inMaintenance) {
            throw new IllegalStateException("Maintenance mode required");
        }
        LOGGER.info("destroyAll called for cluster tiers on {}", (Object)this.clusterUri);
        try {
            this.entityFactory.destroy(this.entityIdentifier);
        }
        catch (EntityBusyException e) {
            throw new CachePersistenceException("Can not delete cluster tiers on " + this.clusterUri, (Throwable)e);
        }
    }

    public boolean handlesResourceType(ResourceType<?> resourceType) {
        return Stream.of(ClusteredResourceType.Types.values()).anyMatch(t -> t.equals(resourceType));
    }

    public PersistableResourceService.PersistenceSpaceIdentifier getPersistenceSpaceIdentifier(String name, CacheConfiguration<?, ?> config) {
        ClusteredSpace clusteredSpace = (ClusteredSpace)this.knownPersistenceSpaces.get(name);
        if (clusteredSpace != null) {
            return clusteredSpace.identifier;
        }
        DefaultClusterCacheIdentifier cacheIdentifier = new DefaultClusterCacheIdentifier(name);
        clusteredSpace = this.knownPersistenceSpaces.putIfAbsent(name, new ClusteredSpace(cacheIdentifier));
        if (clusteredSpace == null) {
            return cacheIdentifier;
        }
        return clusteredSpace.identifier;
    }

    public void releasePersistenceSpaceIdentifier(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier) throws CachePersistenceException {
        ClusteringService.ClusteredCacheIdentifier clusterCacheIdentifier = (ClusteringService.ClusteredCacheIdentifier)identifier;
        if (this.knownPersistenceSpaces.remove(clusterCacheIdentifier.getId()) == null) {
            throw new CachePersistenceException("Unknown identifier: " + clusterCacheIdentifier);
        }
    }

    public StateRepository getStateRepositoryWithin(PersistableResourceService.PersistenceSpaceIdentifier<?> identifier, String name) throws CachePersistenceException {
        ClusteringService.ClusteredCacheIdentifier clusterCacheIdentifier = (ClusteringService.ClusteredCacheIdentifier)identifier;
        ClusteredSpace clusteredSpace = (ClusteredSpace)this.knownPersistenceSpaces.get(clusterCacheIdentifier.getId());
        if (clusteredSpace == null) {
            throw new CachePersistenceException("Clustered space not found for identifier: " + clusterCacheIdentifier);
        }
        ConcurrentMap stateRepositories = clusteredSpace.stateRepositories;
        ClusterStateRepository currentRepo = (ClusterStateRepository)stateRepositories.get(name);
        if (currentRepo != null) {
            return currentRepo;
        }
        ClusterStateRepository newRepo = new ClusterStateRepository(clusterCacheIdentifier, name, (ClusterTierClientEntity)this.clusterTierEntities.get(clusterCacheIdentifier.getId()));
        currentRepo = stateRepositories.putIfAbsent(name, newRepo);
        if (currentRepo == null) {
            return newRepo;
        }
        return currentRepo;
    }

    private void checkStarted() {
        if (!this.isStarted()) {
            throw new IllegalStateException(this.getClass().getName() + " should be started to call destroy");
        }
    }

    public void destroy(String name) throws CachePersistenceException {
        this.checkStarted();
        if (this.entity == null) {
            try {
                this.entity = this.entityFactory.retrieve(this.entityIdentifier, this.configuration.getServerConfiguration());
            }
            catch (EntityNotFoundException entityNotFoundException) {
            }
            catch (TimeoutException e) {
                throw new CachePersistenceException("Could not connect to the cluster tier manager '" + this.entityIdentifier + "'; retrieve operation timed out", (Throwable)e);
            }
            catch (DestroyInProgressException e) {
                this.silentDestroy();
                return;
            }
        }
        try {
            if (this.entity != null) {
                this.entityFactory.destroyClusteredStoreEntity(this.entityIdentifier, name);
            }
        }
        catch (EntityNotFoundException e) {
            LOGGER.debug("Destruction of cluster tier {} failed as it does not exist", (Object)name);
        }
    }

    protected boolean isStarted() {
        return this.entityFactory != null;
    }

    @Override
    public <K, V> ServerStoreProxy getServerStoreProxy(ClusteringService.ClusteredCacheIdentifier cacheIdentifier, Store.Configuration<K, V> storeConfig, Consistency configuredConsistency, ServerStoreProxy.ServerCallback invalidation) throws CachePersistenceException {
        ServerStoreProxy serverStoreProxy;
        ClusterTierClientEntity storeClientEntity;
        String cacheId = cacheIdentifier.getId();
        if (configuredConsistency == null) {
            throw new NullPointerException("Consistency cannot be null");
        }
        ClusteredResourcePool clusteredResourcePool = null;
        for (ClusteredResourceType<? extends ClusteredResourcePool> type : ClusteredResourceType.Types.values()) {
            ClusteredResourcePool pool = (ClusteredResourcePool)storeConfig.getResourcePools().getPoolForResource(type);
            if (pool == null) continue;
            if (clusteredResourcePool != null) {
                throw new IllegalStateException("At most one clustered resource supported for a cache");
            }
            clusteredResourcePool = pool;
        }
        if (clusteredResourcePool == null) {
            throw new IllegalStateException("A clustered resource is required for a clustered cache");
        }
        ServerStoreConfiguration clientStoreConfiguration = new ServerStoreConfiguration(clusteredResourcePool.getPoolAllocation(), storeConfig.getKeyType().getName(), storeConfig.getValueType().getName(), storeConfig.getKeySerializer() == null ? null : storeConfig.getKeySerializer().getClass().getName(), storeConfig.getValueSerializer() == null ? null : storeConfig.getValueSerializer().getClass().getName(), configuredConsistency);
        try {
            storeClientEntity = this.entityFactory.fetchOrCreateClusteredStoreEntity(this.entityIdentifier, cacheId, clientStoreConfiguration, this.configuration.isAutoCreate());
            this.clusterTierEntities.put(cacheId, storeClientEntity);
        }
        catch (EntityNotFoundException e) {
            throw new CachePersistenceException("Cluster tier proxy '" + cacheIdentifier.getId() + "' for entity '" + this.entityIdentifier + "' does not exist.", (Throwable)e);
        }
        switch (configuredConsistency) {
            case STRONG: {
                serverStoreProxy = new StrongServerStoreProxy(cacheId, storeClientEntity, invalidation);
                break;
            }
            case EVENTUAL: {
                serverStoreProxy = new EventualServerStoreProxy(cacheId, storeClientEntity, invalidation);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown consistency : " + (Object)((Object)configuredConsistency)));
            }
        }
        try {
            storeClientEntity.validate(clientStoreConfiguration);
        }
        catch (ClusterTierException e) {
            serverStoreProxy.close();
            throw new CachePersistenceException("Unable to create cluster tier proxy '" + cacheIdentifier.getId() + "' for entity '" + this.entityIdentifier + "'", (Throwable)e);
        }
        catch (TimeoutException e) {
            serverStoreProxy.close();
            throw new CachePersistenceException("Unable to create cluster tier proxy '" + cacheIdentifier.getId() + "' for entity '" + this.entityIdentifier + "'; validate operation timed out", (Throwable)e);
        }
        return serverStoreProxy;
    }

    @Override
    public void releaseServerStoreProxy(ServerStoreProxy storeProxy) {
        this.clusterTierEntities.remove(storeProxy.getCacheId());
        storeProxy.close();
    }

    private void closeConnection() {
        Connection conn = this.clusterConnection;
        this.clusterConnection = null;
        if (conn != null) {
            try {
                conn.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error closing cluster connection: " + e);
            }
        }
    }

    private static class ClusteredSpace {
        private final ClusteringService.ClusteredCacheIdentifier identifier;
        private final ConcurrentMap<String, ClusterStateRepository> stateRepositories;

        ClusteredSpace(ClusteringService.ClusteredCacheIdentifier identifier) {
            this.identifier = identifier;
            this.stateRepositories = new ConcurrentHashMap<String, ClusterStateRepository>();
        }
    }

    private static class DefaultClusterCacheIdentifier
    implements ClusteringService.ClusteredCacheIdentifier {
        private final String id;

        DefaultClusterCacheIdentifier(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public Class<ClusteringService> getServiceType() {
            return ClusteringService.class;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + this.id;
        }
    }
}

