/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.ehcache.clustered.client.config.TimeoutDuration;
import org.ehcache.clustered.client.internal.Timeouts;
import org.ehcache.clustered.client.internal.service.ClusterTierException;
import org.ehcache.clustered.client.internal.service.ClusterTierValidationException;
import org.ehcache.clustered.client.internal.store.ClusterTierClientEntity;
import org.ehcache.clustered.client.internal.store.InternalClusterTierClientEntity;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.messages.ClusterTierReconnectMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;
import org.ehcache.clustered.common.internal.messages.EhcacheResponseType;
import org.ehcache.clustered.common.internal.messages.LifeCycleMessageFactory;
import org.ehcache.clustered.common.internal.messages.ReconnectMessageCodec;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpMessage;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.EndpointDelegate;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.exception.EntityException;

public class SimpleClusterTierClientEntity
implements InternalClusterTierClientEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleClusterTierClientEntity.class);
    private static final Set<EhcacheMessageType> GET_STORE_OPS = EnumSet.of(EhcacheMessageType.GET_STORE);
    private final EntityClientEndpoint<EhcacheEntityMessage, EhcacheEntityResponse> endpoint;
    private final LifeCycleMessageFactory messageFactory;
    private final AtomicLong sequenceGenerator = new AtomicLong(0L);
    private final Object lock = new Object();
    private final ReconnectMessageCodec reconnectMessageCodec = new ReconnectMessageCodec();
    private final Map<Class<? extends EhcacheEntityResponse>, List<ClusterTierClientEntity.ResponseListener<? extends EhcacheEntityResponse>>> responseListeners = new ConcurrentHashMap<Class<? extends EhcacheEntityResponse>, List<ClusterTierClientEntity.ResponseListener<? extends EhcacheEntityResponse>>>();
    private UUID clientId;
    private ClusterTierClientEntity.ReconnectListener reconnectListener = reconnectMessage -> {};
    private ClusterTierClientEntity.DisconnectionListener disconnectionListener = () -> {};
    private Timeouts timeouts = Timeouts.builder().build();
    private String storeIdentifier;
    private volatile boolean connected = true;

    public SimpleClusterTierClientEntity(EntityClientEndpoint<EhcacheEntityMessage, EhcacheEntityResponse> endpoint) {
        this.endpoint = endpoint;
        this.messageFactory = new LifeCycleMessageFactory();
        endpoint.setDelegate(new EndpointDelegate<EhcacheEntityResponse>(){

            @Override
            public void handleMessage(EhcacheEntityResponse messageFromServer) {
                LOGGER.trace("Entity response received from server: {}", (Object)messageFromServer);
                SimpleClusterTierClientEntity.this.fireResponseEvent(messageFromServer);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] createExtendedReconnectData() {
                Object object = SimpleClusterTierClientEntity.this.lock;
                synchronized (object) {
                    ClusterTierReconnectMessage reconnectMessage = new ClusterTierReconnectMessage(SimpleClusterTierClientEntity.this.clientId);
                    SimpleClusterTierClientEntity.this.reconnectListener.onHandleReconnect(reconnectMessage);
                    return SimpleClusterTierClientEntity.this.reconnectMessageCodec.encode(reconnectMessage);
                }
            }

            @Override
            public void didDisconnectUnexpectedly() {
                SimpleClusterTierClientEntity.this.fireDisconnectionEvent();
            }
        });
    }

    @Override
    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
    }

    void fireDisconnectionEvent() {
        this.connected = false;
        this.disconnectionListener.onDisconnection();
    }

    private <T extends EhcacheEntityResponse> void fireResponseEvent(T response) {
        List<ClusterTierClientEntity.ResponseListener<? extends EhcacheEntityResponse>> responseListeners = this.responseListeners.get(response.getClass());
        if (responseListeners == null) {
            LOGGER.warn("Ignoring the response {} as no registered response listener could be found.", response);
            return;
        }
        LOGGER.debug("{} registered response listener(s) for {}", (Object)responseListeners.size(), response.getClass());
        for (ClusterTierClientEntity.ResponseListener<? extends EhcacheEntityResponse> responseListener : responseListeners) {
            responseListener.onResponse(response);
        }
    }

    @Override
    public void close() {
        this.reconnectListener = null;
        this.disconnectionListener = null;
        this.endpoint.close();
    }

    @Override
    public void setClientId(UUID clientId) {
        this.clientId = clientId;
        this.messageFactory.setClientId(clientId);
    }

    @Override
    public UUID getClientId() {
        if (this.clientId == null) {
            throw new IllegalStateException("Client Id cannot be null");
        }
        return this.clientId;
    }

    @Override
    public void setReconnectListener(ClusterTierClientEntity.ReconnectListener reconnectListener) {
        this.reconnectListener = reconnectListener;
    }

    @Override
    public void setDisconnectionListener(ClusterTierClientEntity.DisconnectionListener disconnectionListener) {
        this.disconnectionListener = disconnectionListener;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public <T extends EhcacheEntityResponse> void addResponseListener(Class<T> responseType, ClusterTierClientEntity.ResponseListener<T> responseListener) {
        List<ClusterTierClientEntity.ResponseListener<? extends EhcacheEntityResponse>> responseListeners = this.responseListeners.get(responseType);
        if (responseListeners == null) {
            responseListeners = new CopyOnWriteArrayList<ClusterTierClientEntity.ResponseListener<? extends EhcacheEntityResponse>>();
            this.responseListeners.put(responseType, responseListeners);
        }
        responseListeners.add(responseListener);
    }

    @Override
    public void validate(ServerStoreConfiguration clientStoreConfiguration) throws ClusterTierException, TimeoutException {
        try {
            this.invokeInternal(this.timeouts.getLifecycleOperationTimeout(), this.messageFactory.validateServerStore(this.storeIdentifier, clientStoreConfiguration), false);
        }
        catch (ClusterException e) {
            throw new ClusterTierValidationException("Error validating cluster tier '" + this.storeIdentifier + "'", e);
        }
    }

    @Override
    public void setStoreIdentifier(String storeIdentifier) {
        this.storeIdentifier = storeIdentifier;
    }

    void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Override
    public EhcacheEntityResponse invokeServerStoreOperation(ServerStoreOpMessage message, boolean track) throws ClusterException, TimeoutException {
        return this.invoke(message, track);
    }

    @Override
    public EhcacheEntityResponse invokeStateRepositoryOperation(StateRepositoryOpMessage message, boolean track) throws ClusterException, TimeoutException {
        return this.invoke(message, track);
    }

    @Override
    public void invokeServerStoreOperationAsync(ServerStoreOpMessage message, boolean track) throws MessageCodecException {
        this.internalInvokeAsync(message, track);
    }

    private EhcacheEntityResponse invoke(EhcacheOperationMessage message, boolean track) throws ClusterException, TimeoutException {
        TimeoutDuration timeLimit = this.timeouts.getMutativeOperationTimeout();
        if (GET_STORE_OPS.contains((Object)message.getMessageType())) {
            timeLimit = this.timeouts.getReadOperationTimeout();
        }
        return this.invokeInternal(timeLimit, message, track);
    }

    private EhcacheEntityResponse invokeInternal(TimeoutDuration timeLimit, EhcacheEntityMessage message, boolean track) throws ClusterException, TimeoutException {
        try {
            EhcacheEntityResponse response = SimpleClusterTierClientEntity.waitFor(timeLimit, this.internalInvokeAsync(message, track));
            if (EhcacheResponseType.FAILURE.equals((Object)response.getResponseType())) {
                throw ((EhcacheEntityResponse.Failure)response).getCause();
            }
            return response;
        }
        catch (MessageCodecException | EntityException e) {
            throw new RuntimeException(message + " error: " + e.toString(), e);
        }
        catch (TimeoutException e) {
            String msg = "Timeout exceeded for " + message + " message; " + timeLimit;
            TimeoutException timeoutException = new TimeoutException(msg);
            timeoutException.initCause(e);
            LOGGER.info(msg, (Throwable)timeoutException);
            throw timeoutException;
        }
    }

    private InvokeFuture<EhcacheEntityResponse> internalInvokeAsync(EhcacheEntityMessage message, boolean track) throws MessageCodecException {
        this.getClientId();
        if (track) {
            message.setId(this.sequenceGenerator.getAndIncrement());
        }
        return this.endpoint.beginInvoke().message(message).invoke();
    }

    private static <T extends EntityResponse> T waitFor(TimeoutDuration timeLimit, InvokeFuture<T> future) throws EntityException, TimeoutException {
        boolean interrupted = false;
        long deadlineTimeout = System.nanoTime() + timeLimit.toNanos();
        while (true) {
            try {
                long timeRemaining = deadlineTimeout - System.nanoTime();
                T t = future.getWithTimeout(timeRemaining, TimeUnit.NANOSECONDS);
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

