/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.compression;

import com.tc.io.TCByteArrayOutputStream;
import com.tc.object.compression.CompressedData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class StringCompressionUtil {
    static final char COMPRESSION_FLAG = '\uc0ff';
    static final byte ODD_MARKER = -64;

    public static byte[] stringToUncompressedBin(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    public static CompressedData compressBin(byte[] uncompressed) {
        TCByteArrayOutputStream byteArrayOS = new TCByteArrayOutputStream(4096);
        DeflaterOutputStream dos = new DeflaterOutputStream(byteArrayOS);
        try {
            dos.write(uncompressed);
            dos.close();
            byte[] compressed = byteArrayOS.getInternalArray();
            return new CompressedData(compressed, byteArrayOS.size(), uncompressed.length);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    public static char[] packCompressed(CompressedData compressedData) {
        byte[] bytes = compressedData.getCompressedData();
        int compressedLength = compressedData.getCompressedSize();
        int uncompressedByteLength = compressedData.getUncompressedSize();
        int remainder = StringCompressionUtil.isOdd(compressedLength);
        char[] result = new char[3 + compressedLength / 2 + remainder];
        result[0] = 49407;
        StringCompressionUtil.intToChars(uncompressedByteLength, result, 1);
        int charIndex = 3;
        int startByte = 0;
        if (remainder == 1) {
            result[charIndex++] = StringCompressionUtil.encodeTwoBytesAsChar(-64, bytes[0]);
            startByte = 1;
        }
        for (int i = startByte; i < compressedLength; i += 2) {
            result[charIndex++] = StringCompressionUtil.encodeTwoBytesAsChar(bytes[i], StringCompressionUtil.getLowByte(bytes, compressedLength, i));
        }
        return result;
    }

    static char encodeTwoBytesAsChar(int highByte, byte lowByte) {
        highByte <<= 8;
        highByte = StringCompressionUtil.appendByteToLowBitsOfInt(lowByte, highByte);
        return (char)highByte;
    }

    private static byte getLowByte(byte[] bytes, int compressedLength, int i) {
        byte lowByte = 0;
        if (i + 1 < compressedLength) {
            lowByte = bytes[i + 1];
        }
        return lowByte;
    }

    static int appendByteToLowBitsOfInt(byte lowByte, int anInt) {
        int bitmask = 0xFF & lowByte;
        return anInt |= bitmask;
    }

    static void intToChars(int value, char[] chars, int offset) {
        chars[offset] = (char)(value >> 16);
        chars[offset + 1] = (char)(value & 0xFFFF);
    }

    static int charsToInt(char[] chars, int offset) {
        int high = chars[offset] << 16;
        return high + chars[offset + 1];
    }

    static int isOdd(int num) {
        return num & 1;
    }

    public static CompressedData unpackCompressed(char[] chars) {
        int uncompressedByteLength = StringCompressionUtil.charsToInt(chars, 1);
        byte[] bytes = null;
        int byteIndex = 0;
        for (int i = 3; i < chars.length; ++i) {
            char anInt = chars[i];
            byte highByte = (byte)(anInt >> 8);
            if (byteIndex == 0) {
                int byteLength = (chars.length - 3) * 2;
                if (highByte == -64) {
                    bytes = new byte[byteLength - 1];
                } else {
                    bytes = new byte[byteLength];
                    bytes[byteIndex++] = highByte;
                }
            } else {
                bytes[byteIndex++] = highByte;
            }
            if (byteIndex >= bytes.length) continue;
            bytes[byteIndex++] = (byte)anInt;
        }
        if (bytes == null) {
            bytes = new byte[]{};
        }
        return new CompressedData(bytes, bytes.length, uncompressedByteLength);
    }

    public static byte[] uncompressBin(CompressedData data) {
        try {
            int read;
            int uncompressedLength;
            ByteArrayInputStream bais = new ByteArrayInputStream(data.getCompressedData());
            InflaterInputStream iis = new InflaterInputStream(bais);
            byte[] uncompressed = new byte[uncompressedLength];
            int offset = 0;
            for (uncompressedLength = data.getUncompressedSize(); uncompressedLength > 0 && (read = iis.read(uncompressed, offset, uncompressedLength)) != -1; uncompressedLength -= read) {
                offset += read;
            }
            iis.close();
            return uncompressed;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static boolean isCompressed(char[] compressedString) {
        return compressedString.length > 0 && '\uc0ff' == compressedString[0];
    }

    public static byte[] unpackAndDecompress(char[] compressedString) {
        if (StringCompressionUtil.isCompressed(compressedString)) {
            CompressedData data = StringCompressionUtil.unpackCompressed(compressedString);
            return StringCompressionUtil.uncompressBin(data);
        }
        return null;
    }
}

