/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.impl;

import com.tc.async.api.EventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.async.api.MultiThreadedEventContext;
import com.tc.async.api.Source;
import com.tc.async.api.SpecializedEventContext;
import com.tc.async.api.StageQueueStats;
import com.tc.async.impl.AbstractStageQueueImpl;
import com.tc.async.impl.ContextWrapper;
import com.tc.exception.TCRuntimeException;
import com.tc.logging.TCLoggerProvider;
import com.tc.stats.Stats;
import com.tc.util.Assert;
import com.tc.util.concurrent.QueueFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class SingletonStageQueueImpl<EC>
extends AbstractStageQueueImpl<EC> {
    private final SourceQueueImpl<ContextWrapper<EC>> sourceQueue;

    SingletonStageQueueImpl(QueueFactory<ContextWrapper<EC>> queueFactory, TCLoggerProvider loggerProvider, String stageName, int queueSize) {
        super(loggerProvider, stageName);
        this.sourceQueue = this.createWorkerQueue(queueFactory, queueSize, stageName);
    }

    private SourceQueueImpl<ContextWrapper<EC>> createWorkerQueue(QueueFactory<ContextWrapper<EC>> queueFactory, int queueSize, String stage) {
        AbstractStageQueueImpl.NullStageQueueStatsCollector statsCollector = new AbstractStageQueueImpl.NullStageQueueStatsCollector(stage);
        BlockingQueue<ContextWrapper<EC>> q = null;
        Assert.eval(queueSize > 0);
        q = queueFactory.createInstance(queueSize);
        return new SourceQueueImpl<ContextWrapper<EC>>(q, statsCollector);
    }

    @Override
    public Source<ContextWrapper<EC>> getSource(int index) {
        return index != 0 ? null : this.sourceQueue;
    }

    @Override
    AbstractStageQueueImpl.SourceQueue[] getSources() {
        return new AbstractStageQueueImpl.SourceQueue[]{this.sourceQueue};
    }

    @Override
    public void addSingleThreaded(EC context) {
        Assert.assertNotNull(context);
        Assert.assertFalse(context instanceof MultiThreadedEventContext);
        if (this.isClosed()) {
            throw new IllegalStateException("closed");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Added:" + context + " to:" + this.stageName);
        }
        boolean interrupted = Thread.interrupted();
        AbstractStageQueueImpl.HandledContext<EC> wrapper = new AbstractStageQueueImpl.HandledContext<EC>(context);
        this.deliverToQueue("Single", wrapper);
    }

    @Override
    public void addMultiThreaded(EC context) {
        MultiThreadedEventContext cxt;
        Assert.assertNotNull(context);
        Assert.assertTrue(context instanceof MultiThreadedEventContext);
        if (this.isClosed()) {
            throw new IllegalStateException("closed");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Added:" + context + " to:" + this.stageName);
        }
        ContextWrapper<Object> wrapper = (cxt = (MultiThreadedEventContext)context).flush() ? new FlushingHandledContext(context) : new AbstractStageQueueImpl.HandledContext<EC>(context);
        this.deliverToQueue("Multi", wrapper);
    }

    @Override
    public void addSpecialized(SpecializedEventContext specialized) {
        if (this.isClosed()) {
            throw new IllegalStateException("closed");
        }
        AbstractStageQueueImpl.DirectExecuteContext wrapper = new AbstractStageQueueImpl.DirectExecuteContext(specialized);
        this.deliverToQueue("Specialized", wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverToQueue(String type, ContextWrapper<EC> wrapper) {
        boolean interrupted = Thread.interrupted();
        try {
            while (true) {
                try {
                    this.sourceQueue.put(wrapper);
                }
                catch (InterruptedException e) {
                    this.logger.debug("StageQueue Add: [" + type + "] " + e);
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public int size() {
        return this.sourceQueue.size();
    }

    @Override
    public String toString() {
        return "StageQueue(" + this.stageName + ")";
    }

    @Override
    public void clear() {
        int clearCount = this.sourceQueue.clear();
        this.logger.info("Cleared " + clearCount);
    }

    @Override
    public void enableStatsCollection(boolean enable) {
        StageQueueStats collector = null;
        String name = this.stageName + "[" + this.sourceQueue.getSourceName() + "]";
        if (collector == null || !collector.getName().equals(name)) {
            collector = enable ? new AbstractStageQueueImpl.StageQueueStatsCollectorImpl(name) : new AbstractStageQueueImpl.NullStageQueueStatsCollector(name);
        }
        this.sourceQueue.setStatsCollector((AbstractStageQueueImpl.StageQueueStatsCollector)collector);
    }

    @Override
    public Stats getStats(long frequency) {
        return this.sourceQueue.getStatsCollector();
    }

    @Override
    public Stats getStatsAndReset(long frequency) {
        return this.getStats(frequency);
    }

    @Override
    public boolean isStatsCollectionEnabled() {
        return this.sourceQueue.getStatsCollector() instanceof AbstractStageQueueImpl.StageQueueStatsCollectorImpl;
    }

    @Override
    public void resetStats() {
        this.sourceQueue.getStatsCollector().reset();
    }

    private class FlushingHandledContext<T extends EC>
    implements ContextWrapper<EC> {
        private final EC context;
        private int executionCount = 0;

        public FlushingHandledContext(EC context) {
            this.context = context;
        }

        @Override
        public void runWithHandler(EventHandler<EC> handler) throws EventHandlerException {
            handler.handleEvent(this.context);
        }

        public boolean equals(Object obj) {
            if (this.context.getClass().isInstance(obj)) {
                return this.context.equals(obj);
            }
            return super.equals(obj);
        }
    }

    private final class SourceQueueImpl<W>
    implements AbstractStageQueueImpl.SourceQueue<W> {
        private final BlockingQueue<W> queue;
        private volatile AbstractStageQueueImpl.StageQueueStatsCollector statsCollector;

        public SourceQueueImpl(BlockingQueue<W> queue, AbstractStageQueueImpl.StageQueueStatsCollector statsCollector) {
            this.queue = queue;
            this.statsCollector = statsCollector;
        }

        public String toString() {
            return "SourceQueueImpl{Singleton size=" + this.queue.size() + '}';
        }

        @Override
        public AbstractStageQueueImpl.StageQueueStatsCollector getStatsCollector() {
            return this.statsCollector;
        }

        @Override
        public void setStatsCollector(AbstractStageQueueImpl.StageQueueStatsCollector collector) {
            this.statsCollector = collector;
        }

        @Override
        public int clear() {
            int cleared = 0;
            try {
                while (this.poll(0L) != null) {
                    ++cleared;
                }
                return cleared;
            }
            catch (InterruptedException e) {
                throw new TCRuntimeException(e);
            }
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public W poll(long timeout) throws InterruptedException {
            Object rv = timeout == 0L ? this.queue.poll() : this.queue.poll(timeout, TimeUnit.MILLISECONDS);
            return (W)rv;
        }

        @Override
        public void put(W context) throws InterruptedException {
            this.queue.put(context);
            this.statsCollector.contextAdded();
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public String getSourceName() {
            return "Singleton";
        }
    }
}

