/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config;

import com.tc.logging.TCLogging;
import com.tc.text.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;

public class Directories {
    public static final String TC_INSTALL_ROOT_PROPERTY_NAME = "tc.install-root";
    public static final String TC_INSTALL_ROOT_IGNORE_CHECKS_PROPERTY_NAME = "tc.install-root.ignore-checks";
    public static final String SERVER_LIB_DIR = "lib";
    public static final String SERVER_PLUGIN_API_DIR = "plugins/api";
    public static final String SERVER_PLUGIN_LIB_DIR = "plugins/lib";

    static File getInstallationRoot() throws FileNotFoundException {
        File rootPath;
        boolean ignoreCheck = Boolean.getBoolean(TC_INSTALL_ROOT_IGNORE_CHECKS_PROPERTY_NAME);
        if (ignoreCheck) {
            return new File(System.getProperty("user.dir"));
        }
        String path = System.getProperty(TC_INSTALL_ROOT_PROPERTY_NAME);
        if (StringUtils.isBlank(path)) {
            path = System.getProperty("user.dir");
            TCLogging.getLogger(Directories.class).info("System property \"tc.install-root\" is not set, using working dir (" + path + ") as default location ");
        }
        if (!(rootPath = new File(path).getAbsoluteFile()).isDirectory()) {
            throw new FileNotFoundException("The specified Terracotta installation directory, '" + rootPath + "', located via the value of the system property '" + TC_INSTALL_ROOT_PROPERTY_NAME + "', does not actually exist.");
        }
        return rootPath;
    }

    public static File getServerLibFolder() throws FileNotFoundException {
        return new File(Directories.getInstallationRoot(), SERVER_LIB_DIR);
    }

    public static File getServerPluginsApiDir() throws FileNotFoundException {
        return new File(Directories.getInstallationRoot(), SERVER_PLUGIN_API_DIR);
    }

    public static File getServerPluginsLibDir() throws FileNotFoundException {
        return new File(Directories.getInstallationRoot(), SERVER_PLUGIN_LIB_DIR);
    }
}

