/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.msg.ClientHandshakeAckMessage;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ClientHandshakeAckMessageImpl
extends DSOMessageBase
implements ClientHandshakeAckMessage {
    private static final byte PERSISTENT_SERVER = 1;
    private static final byte ALL_NODES = 2;
    private static final byte THIS_NODE_ID = 3;
    private static final byte SERVER_VERSION = 4;
    private final Set<NodeID> allNodes = new HashSet<NodeID>();
    private boolean persistentServer;
    private ClientID thisNodeId;
    private String serverVersion;

    public ClientHandshakeAckMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public ClientHandshakeAckMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)1, this.persistentServer);
        for (NodeID nodeID : this.allNodes) {
            this.putNVPair((byte)2, nodeID);
        }
        this.putNVPair((byte)3, this.thisNodeId);
        this.putNVPair((byte)4, this.serverVersion);
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 1: {
                this.persistentServer = this.getBooleanValue();
                return true;
            }
            case 2: {
                this.allNodes.add(this.getNodeIDValue());
                return true;
            }
            case 3: {
                this.thisNodeId = (ClientID)this.getNodeIDValue();
                return true;
            }
            case 4: {
                this.serverVersion = this.getStringValue();
                return true;
            }
        }
        return false;
    }

    @Override
    public void initialize(boolean persistent, Set<? extends NodeID> allNodeIDs, ClientID thisNodeID, String sv) {
        this.persistentServer = persistent;
        this.allNodes.addAll(allNodeIDs);
        this.thisNodeId = thisNodeID;
        this.serverVersion = sv;
    }

    @Override
    public boolean getPersistentServer() {
        return this.persistentServer;
    }

    @Override
    public ClientID[] getAllNodes() {
        return this.allNodes.toArray(new ClientID[0]);
    }

    @Override
    public ClientID getThisNodeId() {
        return this.thisNodeId;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }
}

