/*
 * Decompiled with CFR 0.152.
 */
package com.tc.lang;

import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.exception.DatabaseException;
import com.tc.exception.ExceptionHelper;
import com.tc.exception.ExceptionHelperImpl;
import com.tc.exception.RuntimeExceptionHelper;
import com.tc.handler.CallbackStartupExceptionLoggingAdapter;
import com.tc.lang.ThrowableHandler;
import com.tc.logging.CallbackOnExitHandler;
import com.tc.logging.CallbackOnExitState;
import com.tc.logging.TCLogger;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.TCDataFileLockingException;
import com.tc.util.Throwables;
import com.tc.util.concurrent.ThreadUtil;
import com.tc.util.startuplock.FileNotCreatedException;
import com.tc.util.startuplock.LocationNotCreatedException;
import java.lang.reflect.Field;
import java.net.BindException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;

public class ThrowableHandlerImpl
implements ThrowableHandler {
    private static final String OOME_ERROR_MSG = "Fatal error: out of available memory. Exiting...";
    protected final TCLogger logger;
    private final ExceptionHelperImpl helper;
    private final List<CallbackOnExitHandler> callbackOnExitDefaultHandlers = new CopyOnWriteArrayList<CallbackOnExitHandler>();
    private final Map<Class<?>, CallbackOnExitHandler> callbackOnExitExceptionHandlers = new HashMap();
    private final Object dumpLock = new Object();
    private static final long TIME_OUT = TCPropertiesImpl.getProperties().getLong("l2.dump.on.exception.timeout") * 1000L;
    private boolean isExitScheduled;
    private boolean isDumpTaken;

    public ThrowableHandlerImpl(TCLogger logger) {
        this.logger = logger;
        this.helper = new ExceptionHelperImpl();
        this.helper.addHelper(new RuntimeExceptionHelper());
        this.registerStartupExceptionCallbackHandlers();
    }

    @Override
    public void addHelper(ExceptionHelper toAdd) {
        this.helper.addHelper(toAdd);
    }

    protected void registerStartupExceptionCallbackHandlers() {
        this.addCallbackOnExitExceptionHandler(ConfigurationSetupException.class, new CallbackStartupExceptionLoggingAdapter());
        String bindExceptionExtraMessage = ".  Please make sure the server isn't already running or choose a different port.";
        this.addCallbackOnExitExceptionHandler(BindException.class, new CallbackStartupExceptionLoggingAdapter(bindExceptionExtraMessage));
        this.addCallbackOnExitExceptionHandler(DatabaseException.class, new CallbackStartupExceptionLoggingAdapter());
        this.addCallbackOnExitExceptionHandler(LocationNotCreatedException.class, new CallbackStartupExceptionLoggingAdapter());
        this.addCallbackOnExitExceptionHandler(FileNotCreatedException.class, new CallbackStartupExceptionLoggingAdapter());
        this.addCallbackOnExitExceptionHandler(TCDataFileLockingException.class, new CallbackStartupExceptionLoggingAdapter());
    }

    @Override
    public void addCallbackOnExitDefaultHandler(CallbackOnExitHandler callbackOnExitHandler) {
        this.callbackOnExitDefaultHandlers.add(callbackOnExitHandler);
    }

    @Override
    public void addCallbackOnExitExceptionHandler(Class<?> c, CallbackOnExitHandler exitHandler) {
        this.callbackOnExitExceptionHandlers.put(c, exitHandler);
    }

    @Override
    public void handleThrowable(Thread thread, Throwable t) {
        this.handlePossibleOOME(t);
        if (ThrowableHandlerImpl.isThreadGroupDestroyed(thread, t)) {
            this.logger.warn("Ignoring an attempt to start a JMX thread during shutdown.", t);
            return;
        }
        if (ThrowableHandlerImpl.isJMXTerminatedException(t)) {
            this.logger.warn("Ignoring a Thread Service termination error from JMX.", t);
            return;
        }
        if (ThrowableHandlerImpl.isNotificationFetcherThread(thread)) {
            this.logger.warn("Got Exception in JMX Notification forwarding", t);
            return;
        }
        CallbackOnExitState throwableState = new CallbackOnExitState(t);
        this.scheduleExit(throwableState);
        Throwable proximateCause = this.helper.getProximateCause(t);
        Throwable ultimateCause = this.helper.getUltimateCause(t);
        try {
            CallbackOnExitHandler registeredExitHandlerObject = this.callbackOnExitExceptionHandlers.get(proximateCause.getClass());
            if (registeredExitHandlerObject != null) {
                registeredExitHandlerObject.callbackOnExit(throwableState);
            } else {
                registeredExitHandlerObject = this.callbackOnExitExceptionHandlers.get(ultimateCause.getClass());
                if (registeredExitHandlerObject != null) {
                    registeredExitHandlerObject.callbackOnExit(throwableState);
                } else {
                    this.handleDefaultException(thread, throwableState);
                }
            }
        }
        catch (Throwable throwable) {
            this.logger.error("Error while handling uncaught expection" + t.getCause(), throwable);
        }
        this.exit(throwableState);
    }

    private static boolean isThreadGroupDestroyed(Thread thread, Throwable t) {
        if (t instanceof IllegalThreadStateException) {
            StackTraceElement[] stack = t.getStackTrace();
            StackTraceElement bottom = stack[stack.length - 1];
            if (stack[0].getClassName().equals("java.lang.ThreadGroup") && stack[0].getMethodName().equals("addUnstarted") && bottom.getClassName().equals("javax.management.remote.generic.GenericConnectorServer$Receiver") && bottom.getMethodName().equals("run")) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlePossibleOOME(Throwable t) {
        Throwable rootCause = Throwables.getRootCause(t);
        if (rootCause instanceof OutOfMemoryError) {
            try {
                this.logger.error(OOME_ERROR_MSG);
                String msg = rootCause.getMessage();
                if (msg != null && msg.length() > 0) {
                    this.logger.error(msg);
                }
            }
            finally {
                this.exit(3);
            }
        }
    }

    private synchronized void scheduleExit(final CallbackOnExitState throwableState) {
        if (this.isExitScheduled) {
            return;
        }
        this.isExitScheduled = true;
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                ThrowableHandlerImpl.this.exit(throwableState);
            }
        };
        Timer timer = new Timer("Dump On Timeout Timer");
        timer.schedule(timerTask, TIME_OUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDefaultException(Thread thread, CallbackOnExitState throwableState) {
        this.logException(thread, throwableState);
        Object object = this.dumpLock;
        synchronized (object) {
            if (!this.isDumpTaken) {
                this.isDumpTaken = true;
                for (CallbackOnExitHandler handler : this.callbackOnExitDefaultHandlers) {
                    handler.callbackOnExit(throwableState);
                }
            }
        }
    }

    private void logException(Thread thread, CallbackOnExitState throwableState) {
        try {
            throwableState.getThrowable().printStackTrace(System.err);
            System.err.flush();
            this.logger.error("Thread:" + thread + " got an uncaught exception. calling CallbackOnExitDefaultHandlers.", throwableState.getThrowable());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void exit(CallbackOnExitState throwableState) {
        boolean autoRestart = TCPropertiesImpl.getProperties().getBoolean("l2.nha.autoRestart");
        this.logger.info("ExitState : " + throwableState + "; AutoRestart: " + autoRestart);
        if (autoRestart && throwableState.isRestartNeeded()) {
            this.exit(11);
        } else {
            this.exit(2);
        }
    }

    protected synchronized void exit(int status) {
        ThreadUtil.reallySleep(2000L);
        System.exit(status);
    }

    private static boolean isNotificationFetcherThread(Thread thread) {
        try {
            Field runnableField = thread.getClass().getDeclaredField("target");
            runnableField.setAccessible(true);
            Object runnable = runnableField.get(thread);
            return runnable != null && runnable.getClass().getSimpleName().equals("NotifFetcher");
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static boolean isJMXTerminatedException(Throwable throwable) {
        return throwable instanceof IllegalStateException && throwable.getMessage().contains("The Thread Service has been terminated.");
    }
}

