/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.runtime;

import com.tc.object.locks.ThreadID;
import com.tc.util.runtime.ThreadIDMap;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ThreadIDMapImpl
implements ThreadIDMap {
    private final ReferenceQueue<ThreadID> referenceQueue = new ReferenceQueue();
    private final Map<Long, WeakReference<ThreadID>> id2ThreadIDMap = new ConcurrentHashMap<Long, WeakReference<ThreadID>>();
    private Thread collectorThread;

    @Override
    public synchronized void addTCThreadID(ThreadID tcThreadID) {
        this.cleanupReferenceQueue();
        this.id2ThreadIDMap.put(Thread.currentThread().getId(), new WeakReference<ThreadID>(tcThreadID, this.referenceQueue));
    }

    @Override
    public synchronized ThreadID getTCThreadID(Long javaThreadId) {
        ThreadID direct;
        this.cleanupReferenceQueue();
        WeakReference<ThreadID> tid = this.id2ThreadIDMap.get(javaThreadId);
        if (tid != null && (direct = (ThreadID)tid.get()) != null) {
            return direct;
        }
        return ThreadID.NULL_ID;
    }

    private void cleanupReferenceQueue() {
        Reference<ThreadID> ref;
        while ((ref = this.referenceQueue.poll()) != null) {
            for (Map.Entry<Long, WeakReference<ThreadID>> entry : this.id2ThreadIDMap.entrySet()) {
                if (!entry.getValue().equals(ref)) continue;
                this.id2ThreadIDMap.remove(entry.getKey());
            }
        }
    }

    public synchronized int getSize() {
        return this.id2ThreadIDMap.size();
    }
}

