/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.entity.VoltronEntityMessage;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.object.ExceptionUtils;
import com.tc.object.tx.TransactionID;
import com.tc.tracing.Trace;
import com.tc.util.Assert;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.exception.EntityException;

public class InFlightMessage
implements InvokeFuture<byte[]> {
    private final VoltronEntityMessage message;
    private final Set<VoltronEntityMessage.Acks> pendingAcks;
    private final Set<Thread> waitingThreads;
    private boolean isSent;
    private EntityException exception;
    private byte[] value;
    private boolean canSetResult;
    private boolean getCanComplete;
    private final boolean blockGetOnRetired;
    private final Trace trace;

    public InFlightMessage(VoltronEntityMessage message, Set<VoltronEntityMessage.Acks> acks, boolean shouldBlockGetOnRetire) {
        this.message = message;
        this.pendingAcks = EnumSet.noneOf(VoltronEntityMessage.Acks.class);
        this.pendingAcks.addAll(acks);
        this.waitingThreads = new HashSet<Thread>();
        this.blockGetOnRetired = shouldBlockGetOnRetire;
        this.canSetResult = true;
        this.trace = Trace.newTrace(message, "InFlightMessage");
    }

    public VoltronEntityMessage getMessage() {
        return this.message;
    }

    public TransactionID getTransactionID() {
        return this.message.getTransactionID();
    }

    public boolean send() {
        Trace.activeTrace().log("InFlightMessage.send()");
        Assert.assertFalse(this.isSent);
        this.isSent = true;
        return ((TCMessage)((Object)this.message)).send();
    }

    public synchronized void waitForAcks() {
        Trace.activeTrace().log("InFlightMessage.waitForAcks");
        boolean interrupted = false;
        while (!this.pendingAcks.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized void sent() {
        this.trace.log("Received ACK: " + (Object)((Object)VoltronEntityMessage.Acks.SENT));
        if (this.pendingAcks.remove((Object)VoltronEntityMessage.Acks.SENT) && this.pendingAcks.isEmpty()) {
            this.notifyAll();
        }
    }

    public synchronized void received() {
        this.trace.log("Received ACK: " + (Object)((Object)VoltronEntityMessage.Acks.RECEIVED));
        if (this.pendingAcks.remove((Object)VoltronEntityMessage.Acks.RECEIVED) && this.pendingAcks.isEmpty()) {
            this.notifyAll();
        }
    }

    @Override
    public synchronized void interrupt() {
        for (Thread waitingThread : this.waitingThreads) {
            waitingThread.interrupt();
        }
    }

    @Override
    public synchronized boolean isDone() {
        return this.getCanComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] get() throws InterruptedException, EntityException {
        this.trace.log("get()");
        Thread callingThread = Thread.currentThread();
        boolean didAdd = this.waitingThreads.add(callingThread);
        Assert.assertTrue(didAdd);
        try {
            while (!this.getCanComplete) {
                this.wait();
            }
        }
        finally {
            this.waitingThreads.remove(callingThread);
        }
        if (this.exception != null) {
            throw ExceptionUtils.addLocalStackTraceToEntityException(this.exception);
        }
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] getWithTimeout(long timeout, TimeUnit unit) throws InterruptedException, EntityException, TimeoutException {
        this.trace.log("getWithTimeout()");
        Thread callingThread = Thread.currentThread();
        boolean didAdd = this.waitingThreads.add(callingThread);
        Assert.assertTrue(didAdd);
        long end = System.nanoTime() + unit.toNanos(timeout);
        try {
            while (!this.getCanComplete) {
                long timing = end - System.nanoTime();
                if (timing <= 0L) {
                    throw new TimeoutException();
                }
                this.wait(timing / TimeUnit.MILLISECONDS.toNanos(1L), (int)(timing % TimeUnit.MILLISECONDS.toNanos(1L)));
            }
        }
        finally {
            this.waitingThreads.remove(callingThread);
        }
        if (this.exception != null) {
            throw ExceptionUtils.addLocalStackTraceToEntityException(this.exception);
        }
        return this.value;
    }

    public synchronized void setResult(byte[] value, EntityException error) {
        this.trace.log("Received Result: " + value + " ; Exception: " + (error != null ? error.getLocalizedMessage() : "None"));
        this.pendingAcks.remove((Object)VoltronEntityMessage.Acks.COMPLETED);
        if (error != null) {
            Assert.assertNull(value);
            this.pendingAcks.clear();
            this.exception = error;
            this.getCanComplete = true;
            this.notifyAll();
        } else {
            Assert.assertNull(error);
            if (this.canSetResult) {
                this.value = value;
                if (!this.blockGetOnRetired) {
                    this.getCanComplete = true;
                    this.notifyAll();
                }
                this.canSetResult = this.blockGetOnRetired;
            }
        }
    }

    public synchronized void retired() {
        this.trace.log("Received ACK: " + (Object)((Object)VoltronEntityMessage.Acks.RETIRED));
        this.pendingAcks.remove((Object)VoltronEntityMessage.Acks.RETIRED);
        if (this.blockGetOnRetired) {
            this.getCanComplete = true;
        }
        this.notifyAll();
    }
}

