/*
 * Decompiled with CFR 0.152.
 */
package com.tc.io.serializer;

import com.tc.io.TCDataOutput;
import com.tc.object.dna.api.DNAEncoding;
import com.tc.object.dna.impl.SerializerDNAEncodingImpl;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class TCObjectOutputStream
implements ObjectOutput,
TCDataOutput {
    private static final DNAEncoding SERIALIZER_ENCODING = new SerializerDNAEncodingImpl();
    protected final OutputStream out;

    public TCObjectOutputStream(OutputStream out) {
        this.out = out;
    }

    @Override
    public void writeObject(Object obj) {
        if (obj != null && obj.getClass().isArray()) {
            SERIALIZER_ENCODING.encodeArray(obj, this);
        } else {
            SERIALIZER_ENCODING.encode(obj, this);
        }
    }

    @Override
    public void writeString(String string) {
        if (string == null) {
            this.writeInt(-1);
            return;
        }
        try {
            byte[] strbytes = string.getBytes("UTF-8");
            this.writeInt(strbytes.length);
            this.write(strbytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeBytes(String s) {
        int len = s.length();
        try {
            for (int i = 0; i < len; ++i) {
                this.out.write((byte)s.charAt(i));
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeChars(String s) {
        int len = s.length();
        try {
            for (int i = 0; i < len; ++i) {
                char v = s.charAt(i);
                this.out.write(v >>> 8 & 0xFF);
                this.out.write(v >>> 0 & 0xFF);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeUTF(String str) {
        this.writeString(str);
    }

    @Override
    public void close() {
        this.flush();
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void write(int b) {
        try {
            this.out.write(b);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void write(byte[] value) {
        this.write(value, 0, value.length);
    }

    @Override
    public void write(byte[] value, int offset, int length) {
        try {
            this.out.write(value, offset, length);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeBoolean(boolean value) {
        try {
            this.out.write(value ? 1 : 0);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeByte(int value) {
        try {
            this.out.write(value);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeChar(int v) {
        try {
            this.out.write(v >>> 8 & 0xFF);
            this.out.write(v >>> 0 & 0xFF);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeDouble(double value) {
        this.writeLong(Double.doubleToLongBits(value));
    }

    @Override
    public void writeFloat(float value) {
        this.writeInt(Float.floatToIntBits(value));
    }

    @Override
    public void writeInt(int v) {
        try {
            this.out.write(v >>> 24 & 0xFF);
            this.out.write(v >>> 16 & 0xFF);
            this.out.write(v >>> 8 & 0xFF);
            this.out.write(v >>> 0 & 0xFF);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeLong(long v) {
        byte[] writeBuffer = new byte[]{(byte)(v >>> 56), (byte)(v >>> 48), (byte)(v >>> 40), (byte)(v >>> 32), (byte)(v >>> 24), (byte)(v >>> 16), (byte)(v >>> 8), (byte)(v >>> 0)};
        try {
            this.out.write(writeBuffer, 0, 8);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void writeShort(int v) {
        try {
            this.out.write(v >>> 8 & 0xFF);
            this.out.write(v >>> 0 & 0xFF);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

