/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.tcm;

import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.NullMessageMonitor;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.properties.TCProperties;
import com.tc.text.StringFormatter;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;

public class MessageMonitorImpl
implements MessageMonitor {
    private final Map<TCMessageType, MessageCounter> counters = new TreeMap<TCMessageType, MessageCounter>(new TCMessageTypeComparator());
    private final StringFormatter formatter = new StringFormatter();
    private final Timer timer = new Timer("MessageMonitor logger", true);
    private int maxTypeWidth = 0;

    public static MessageMonitor createMonitor(TCProperties tcProps, Logger logger) {
        MessageMonitor mm;
        if (tcProps.getBoolean("tcm.monitor.enabled", false)) {
            mm = new MessageMonitorImpl();
            ((MessageMonitorImpl)mm).startLogging(logger, tcProps.getInt("tcm.monitor.delay"));
        } else {
            mm = new NullMessageMonitor();
        }
        return mm;
    }

    public void startLogging(final Logger logger, int intervalSeconds) {
        if (intervalSeconds < 1) {
            throw new IllegalArgumentException("invalid interval: " + intervalSeconds);
        }
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                logger.info(MessageMonitorImpl.this.toString());
            }
        };
        this.timer.scheduleAtFixedRate(task, 0L, (long)(intervalSeconds * 1000));
    }

    @Override
    public void newIncomingMessage(TCMessage message) {
        this.getOrCreateMessageCounter(message.getMessageType()).newIncomingMessage(message);
    }

    @Override
    public void newOutgoingMessage(TCMessage message) {
        this.getOrCreateMessageCounter(message.getMessageType()).newOutgoingMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageCounter getOrCreateMessageCounter(TCMessageType type) {
        Map<TCMessageType, MessageCounter> map = this.counters;
        synchronized (map) {
            MessageCounter rv = this.counters.get(type);
            if (rv == null) {
                this.maxTypeWidth = Math.max(this.maxTypeWidth, type.getTypeName().length());
                rv = new MessageCounter(this.formatter, type.getTypeName());
                this.counters.put(type, rv);
            }
            return rv;
        }
    }

    public Map<TCMessageType, MessageCounter> getCounters() {
        return this.counters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer rv = new StringBuffer(nl);
        Map<TCMessageType, MessageCounter> map = this.counters;
        synchronized (map) {
            for (MessageCounter counter : this.counters.values()) {
                rv.append(counter.toString(this.maxTypeWidth)).append(nl);
            }
        }
        return rv.toString();
    }

    private static class TCMessageTypeComparator
    implements Comparator<TCMessageType>,
    Serializable {
        private TCMessageTypeComparator() {
        }

        @Override
        public int compare(TCMessageType t1, TCMessageType t2) {
            return t1.getTypeName().compareTo(t2.getTypeName());
        }
    }

    public static class MessageCounter {
        private final AtomicLong incomingCount = new AtomicLong(0L);
        private final AtomicLong incomingData = new AtomicLong(0L);
        private final AtomicLong outgoingCount = new AtomicLong(0L);
        private final AtomicLong outgoingData = new AtomicLong(0L);
        private final StringFormatter formatter;
        private final String name;

        private MessageCounter(StringFormatter formatter, String name) {
            this.formatter = formatter;
            this.name = name;
        }

        private synchronized void newIncomingMessage(TCMessage message) {
            this.incomingCount.incrementAndGet();
            this.incomingData.addAndGet(message.getTotalLength());
        }

        private synchronized void newOutgoingMessage(TCMessage message) {
            this.outgoingCount.incrementAndGet();
            this.outgoingData.addAndGet(message.getTotalLength());
        }

        public String toString(int nameWidth) {
            return this.formatter.rightPad(nameWidth, this.name) + " | IN: " + this.formatter.leftPad(15, this.incomingCount) + ", " + this.formatter.leftPad(30, this.incomingData) + " bytes " + "| OUT: " + this.formatter.leftPad(15, this.outgoingCount) + ", " + this.formatter.leftPad(30, this.outgoingData) + " bytes";
        }

        public AtomicLong getIncomingCount() {
            return this.incomingCount;
        }

        public AtomicLong getIncomingData() {
            return this.incomingData;
        }

        public AtomicLong getOutgoingCount() {
            return this.outgoingCount;
        }

        public AtomicLong getOutgoingData() {
            return this.outgoingData;
        }

        public String getName() {
            return this.name;
        }
    }
}

