/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import com.tc.object.ObjectID;
import com.tc.util.BasicObjectIDSet;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;

public abstract class ObjectIDSet
extends AbstractSet<ObjectID>
implements SortedSet<ObjectID>,
TCSerializable<ObjectIDSet> {
    public static final ObjectIDSet EMPTY_OBJECT_ID_SET = ObjectIDSet.unmodifiableObjectIDSet(new BasicObjectIDSet());
    protected static final Comparator<Range> RANGE_COMPARATOR = new Comparator<Range>(){

        @Override
        public int compare(Range o1, Range o2) {
            return (int)(o1.getStart() - o2.getStart());
        }
    };

    @Override
    public SortedSet<ObjectID> subSet(ObjectID fromElement, ObjectID toElement) {
        throw new UnsupportedOperationException("Implement me!");
    }

    @Override
    public SortedSet<ObjectID> headSet(ObjectID toElement) {
        throw new UnsupportedOperationException("Implement me!");
    }

    @Override
    public SortedSet<ObjectID> tailSet(ObjectID fromElement) {
        throw new UnsupportedOperationException("Implement me!");
    }

    @Override
    public ObjectID first() {
        throw new UnsupportedOperationException("Implement me!");
    }

    @Override
    public ObjectID last() {
        throw new UnsupportedOperationException("Implement me!");
    }

    @Override
    public Comparator<? super ObjectID> comparator() {
        return new Comparator<ObjectID>(){

            @Override
            public int compare(ObjectID o1, ObjectID o2) {
                return o1.compareTo(o2);
            }
        };
    }

    protected abstract void insertRange(Range var1);

    protected abstract Collection<? extends Range> ranges();

    @Override
    public final void serializeTo(TCByteBufferOutput serialOutput) {
        Collection<? extends Range> ranges = this.ranges();
        serialOutput.writeInt(ranges.size());
        for (Range range : ranges) {
            serialOutput.writeLong(range.getStart());
            serialOutput.writeInt(range.getBitmap().length);
            for (int i = 0; i < range.getBitmap().length; ++i) {
                serialOutput.writeLong(range.getBitmap()[i]);
            }
        }
    }

    @Override
    public final ObjectIDSet deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        int size = serialInput.readInt();
        for (int i = 0; i < size; ++i) {
            long start = serialInput.readLong();
            long[] bitmap = new long[serialInput.readInt()];
            for (int j = 0; j < bitmap.length; ++j) {
                bitmap[j] = serialInput.readLong();
            }
            this.insertRange(new BasicRange(start, bitmap));
        }
        return this;
    }

    public static ObjectIDSet unmodifiableObjectIDSet(ObjectIDSet s) {
        return new UnmodifiableObjectIDSet(s);
    }

    private static class UnmodifiableObjectIDSet
    extends ObjectIDSet {
        private final ObjectIDSet delegate;

        private UnmodifiableObjectIDSet(ObjectIDSet delegate) {
            this.delegate = delegate;
        }

        @Override
        protected void insertRange(Range range) {
            throw new UnsupportedOperationException("Implement me!");
        }

        @Override
        protected Collection<? extends Range> ranges() {
            return this.delegate.ranges();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public Iterator<ObjectID> iterator() {
            return new Iterator<ObjectID>(){
                Iterator<ObjectID> i;
                {
                    this.i = UnmodifiableObjectIDSet.this.delegate.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public ObjectID next() {
                    return this.i.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean add(ObjectID id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends ObjectID> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class BasicRange
    implements Range {
        private final long start;
        private final long[] bitmap;

        BasicRange(long start, long[] bitmap) {
            this.start = start;
            this.bitmap = bitmap;
        }

        @Override
        public long getStart() {
            return this.start;
        }

        @Override
        public long[] getBitmap() {
            return this.bitmap;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("BasicRange{");
            sb.append("start=").append(this.start);
            sb.append(", bitmap=").append(Arrays.toString(this.bitmap));
            sb.append('}');
            return sb.toString();
        }
    }

    protected static interface Range {
        public long getStart();

        public long[] getBitmap();
    }
}

