/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.utils;

import java.nio.ByteBuffer;
import org.terracotta.runnel.utils.CorruptDataException;
import org.terracotta.runnel.utils.LimitReachedException;
import org.terracotta.runnel.utils.VLQ;

public class ReadBuffer {
    private final ByteBuffer byteBuffer;
    private final int limit;

    public ReadBuffer(ByteBuffer byteBuffer) {
        this(byteBuffer, byteBuffer.remaining());
    }

    private ReadBuffer(ByteBuffer byteBuffer, int limit) {
        this.byteBuffer = byteBuffer;
        this.limit = byteBuffer.position() + limit;
        if (this.limit > byteBuffer.capacity()) {
            throw new LimitReachedException();
        }
    }

    public Boolean getBoolean() {
        if (this.byteBuffer.position() + 1 > this.limit) {
            throw new LimitReachedException();
        }
        return this.byteBuffer.get() == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public Double getDouble() {
        if (this.byteBuffer.position() + 8 > this.limit) {
            throw new LimitReachedException();
        }
        return this.byteBuffer.getDouble();
    }

    public Long getLong() {
        if (this.byteBuffer.position() + 8 > this.limit) {
            throw new LimitReachedException();
        }
        return this.byteBuffer.getLong();
    }

    public Character getChar() {
        if (this.byteBuffer.position() + 2 > this.limit) {
            throw new LimitReachedException();
        }
        return Character.valueOf(this.byteBuffer.getChar());
    }

    public Integer getInt() {
        if (this.byteBuffer.position() + 4 > this.limit) {
            throw new LimitReachedException();
        }
        return this.byteBuffer.getInt();
    }

    public int getVlqInt() {
        return VLQ.decode(this);
    }

    byte getByte() {
        if (this.byteBuffer.position() + 1 > this.limit) {
            throw new LimitReachedException();
        }
        return this.byteBuffer.get();
    }

    public ByteBuffer getByteBuffer(int size) {
        if (this.byteBuffer.position() + size > this.limit) {
            throw new LimitReachedException();
        }
        ByteBuffer slice = this.byteBuffer.slice();
        slice.limit(size);
        this.byteBuffer.position(this.byteBuffer.position() + size);
        return slice;
    }

    public String getString(int size) {
        if (this.byteBuffer.position() + size > this.limit) {
            throw new LimitReachedException();
        }
        ByteBuffer slice = this.byteBuffer.slice();
        slice.limit(size);
        String s = this.readString(slice);
        this.byteBuffer.position(this.byteBuffer.position() + size);
        return s;
    }

    private String readString(ByteBuffer binary) {
        byte a;
        int i;
        StringBuilder sb = new StringBuilder(binary.remaining());
        int end = binary.limit();
        for (i = binary.position(); i < end && ((a = binary.get(i)) & 0x80) == 0; ++i) {
            sb.append((char)a);
        }
        while (i < end) {
            a = binary.get(i);
            if ((a & 0x80) == 0) {
                sb.append((char)a);
            } else if ((a & 0xE0) == 192) {
                sb.append((char)((a & 0x1F) << 6 | binary.get(++i) & 0x3F));
            } else if ((a & 0xF0) == 224) {
                sb.append((char)((a & 0xF) << 12 | (binary.get(++i) & 0x3F) << 6 | binary.get(++i) & 0x3F));
            } else {
                int codepoint;
                if ((a & 0xF8) == 240) {
                    codepoint = (a & 7) << 18 | (binary.get(++i) & 0x3F) << 12 | (binary.get(++i) & 0x3F) << 6 | binary.get(++i) & 0x3F;
                } else if ((a & 0xFC) == 248) {
                    codepoint = (a & 3) << 24 | (binary.get(++i) & 0x3F) << 18 | (binary.get(++i) & 0x3F) << 12 | (binary.get(++i) & 0x3F) << 6 | binary.get(++i) & 0x3F;
                } else if ((a & 0xFE) == 252) {
                    codepoint = (a & 1) << 30 | (binary.get(++i) & 0x3F) << 24 | (binary.get(++i) & 0x3F) << 18 | (binary.get(++i) & 0x3F) << 12 | (binary.get(++i) & 0x3F) << 6 | binary.get(++i) & 0x3F;
                } else {
                    throw new CorruptDataException("Unexpected encoding");
                }
                sb.appendCodePoint(codepoint);
            }
            ++i;
        }
        return sb.toString();
    }

    public boolean limitReached() {
        return this.byteBuffer.position() == this.limit;
    }

    public void skipAll() {
        this.byteBuffer.position(this.limit);
    }

    public void skip(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size cannot be < 0");
        }
        int targetPosition = this.byteBuffer.position() + size;
        if (targetPosition > this.limit) {
            throw new LimitReachedException();
        }
        this.byteBuffer.position(targetPosition);
    }

    public ReadBuffer limit(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size cannot be < 0");
        }
        return new ReadBuffer(this.byteBuffer, size);
    }
}

