/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.net.TCSocketAddress;
import com.tc.net.core.TCConnection;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.protocol.transport.ConnectionHealthChecker;
import com.tc.net.protocol.transport.ConnectionHealthCheckerContext;
import com.tc.net.protocol.transport.ConnectionHealthCheckerContextImpl;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.HealthCheckerConfig;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportBase;
import com.tc.util.Assert;
import com.tc.util.concurrent.SetOnceFlag;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHealthCheckerImpl
implements ConnectionHealthChecker {
    private final Logger logger;
    private final Thread monitorThread;
    private final HealthCheckerMonitorThreadEngine monitorThreadEngine;
    private final SetOnceFlag shutdown = new SetOnceFlag();
    private final SetOnceFlag started = new SetOnceFlag();

    public ConnectionHealthCheckerImpl(HealthCheckerConfig healthCheckerConfig, TCConnectionManager connManager) {
        Assert.assertNotNull(healthCheckerConfig);
        Assert.eval(healthCheckerConfig.isHealthCheckerEnabled());
        this.logger = LoggerFactory.getLogger(ConnectionHealthCheckerImpl.class.getName() + ": " + healthCheckerConfig.getHealthCheckerName());
        this.monitorThreadEngine = this.getHealthMonitorThreadEngine(healthCheckerConfig, connManager, this.logger);
        this.monitorThread = new Thread((Runnable)this.monitorThreadEngine, "HealthChecker");
        this.monitorThread.setDaemon(true);
    }

    protected HealthCheckerMonitorThreadEngine getHealthMonitorThreadEngine(HealthCheckerConfig config, TCConnectionManager connectionManager, Logger loger) {
        return new HealthCheckerMonitorThreadEngine(config, connectionManager, loger);
    }

    @Override
    public void start() {
        if (this.started.attemptSet()) {
            this.monitorThread.start();
            this.logger.info("HealthChecker Started");
        } else {
            this.logger.warn("HealthChecker already started");
        }
    }

    @Override
    public void stop() {
        if (this.shutdown.attemptSet()) {
            this.monitorThreadEngine.stop();
            this.logger.debug("HealthChecker STOP requested");
        } else {
            this.logger.warn("HealthChecker STOP already requested");
        }
    }

    public boolean isRunning() {
        return this.started.isSet();
    }

    @Override
    public void notifyTransportClosed(MessageTransport transport) {
        if (this.monitorThreadEngine.removeConnection(transport)) {
            TCSocketAddress remoteAddress = transport.getRemoteAddress();
            if (remoteAddress != null) {
                this.logger.info("Connection to [" + remoteAddress.getCanonicalStringForm() + "] CLOSED. Health Monitoring for this node is now disabled.");
            } else {
                this.logger.info("Connection " + transport.getConnectionId() + " CLOSED. Health Monitor for this node is disabled.");
            }
        }
    }

    @Override
    public void notifyTransportConnectAttempt(MessageTransport transport) {
    }

    @Override
    public void notifyTransportConnected(MessageTransport transport) {
        this.monitorThreadEngine.addConnection(transport);
    }

    @Override
    public void notifyTransportDisconnected(MessageTransport transport, boolean forcedDisconnect) {
        if (this.monitorThreadEngine.removeConnection(transport)) {
            TCSocketAddress remoteAddress = transport.getRemoteAddress();
            if (remoteAddress != null) {
                this.logger.info("Connection to [" + remoteAddress.getCanonicalStringForm() + "] DISCONNECTED. Health Monitoring for this node is now disabled.");
            } else {
                this.logger.info("Connection " + transport.getConnectionId() + " DISCONNECTED. Health Monitor for this node is disabled.");
            }
        }
    }

    @Override
    public void notifyTransportReconnectionRejected(MessageTransport transport) {
    }

    public int getTotalConnsUnderMonitor() {
        return this.monitorThreadEngine.getTotalConnectionsUnderMonitor();
    }

    public long getTotalProbesSentOnAllConns() {
        return this.monitorThreadEngine.getTotalProbesSentOnAllConnections();
    }

    static class HealthCheckerMonitorThreadEngine
    implements Runnable {
        private final ConcurrentMap<ConnectionID, MessageTransportBase> connectionMap = new ConcurrentHashMap<ConnectionID, MessageTransportBase>();
        private final long pingIdleTime;
        private final long pingInterval;
        private final int pingProbes;
        private final long checkTimeInterval;
        private final SetOnceFlag stop = new SetOnceFlag();
        private final HealthCheckerConfig config;
        private final Logger logger;
        private final TCConnectionManager connectionManager;
        private final AtomicLong lastCheckTime = new AtomicLong(System.currentTimeMillis());

        public HealthCheckerMonitorThreadEngine(HealthCheckerConfig healthCheckerConfig, TCConnectionManager connectionManager, Logger logger) {
            this.pingIdleTime = healthCheckerConfig.getPingIdleTimeMillis();
            this.pingInterval = healthCheckerConfig.getPingIntervalMillis();
            this.pingProbes = healthCheckerConfig.getPingProbes();
            this.checkTimeInterval = healthCheckerConfig.getCheckTimeInterval();
            this.connectionManager = connectionManager;
            this.config = healthCheckerConfig;
            Assert.assertNotNull(logger);
            this.logger = logger;
            if (this.pingIdleTime - this.pingInterval < 0L || this.pingIdleTime <= 0L || this.pingInterval <= 0L || this.pingProbes <= 0) {
                logger.info("ping_interval period should be less than ping_idletime and ping Ideltime/Interval/Probes cannot be 0 or negative.");
                logger.info("Disabling HealthChecker for this CommsMgr");
                throw new AssertionError((Object)"HealthChecker Config Error");
            }
        }

        private void addConnection(MessageTransport transport) {
            MessageTransportBase mtb = (MessageTransportBase)transport;
            mtb.setHealthCheckerContext(this.getHealthCheckerContext(mtb, this.config, this.connectionManager));
            this.connectionMap.put(transport.getConnectionId(), mtb);
        }

        private boolean removeConnection(MessageTransport transport) {
            return this.connectionMap.remove(transport.getConnectionId()) != null;
        }

        protected ConnectionHealthCheckerContext getHealthCheckerContext(MessageTransportBase transport, HealthCheckerConfig conf, TCConnectionManager connManager) {
            return new ConnectionHealthCheckerContextImpl(transport, conf, connManager);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            this.stop.attemptSet();
            SetOnceFlag setOnceFlag = this.stop;
            synchronized (setOnceFlag) {
                this.stop.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                if (this.stop.isSet()) {
                    this.logger.info("HealthChecker SHUTDOWN");
                    return;
                }
                boolean canCheckTime = this.canCheckTime();
                Iterator connectionIterator = this.connectionMap.values().iterator();
                while (connectionIterator.hasNext()) {
                    MessageTransportBase mtb = (MessageTransportBase)connectionIterator.next();
                    TCConnection conn = mtb.getConnection();
                    if (conn == null || !mtb.isConnected()) {
                        this.logger.info("[" + (conn == null ? null : conn.getRemoteAddress().getCanonicalStringForm()) + "] is not connected. Health Monitoring for this node is now disabled.");
                        connectionIterator.remove();
                        continue;
                    }
                    ConnectionHealthCheckerContext connContext = mtb.getHealthCheckerContext();
                    if (conn.getIdleReceiveTime() >= this.pingIdleTime) {
                        if (!connContext.probeIfAlive()) {
                            this.logger.error("Declared connection dead " + mtb.getConnectionId() + " idle time " + conn.getIdleReceiveTime() + "ms");
                            mtb.disconnect();
                            connectionIterator.remove();
                        }
                    } else {
                        connContext.refresh();
                    }
                    if (!canCheckTime) continue;
                    connContext.checkTime();
                }
                if (canCheckTime) {
                    this.lastCheckTime.set(System.currentTimeMillis());
                }
                SetOnceFlag setOnceFlag = this.stop;
                synchronized (setOnceFlag) {
                    try {
                        this.stop.wait(this.pingInterval);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
        }

        boolean canCheckTime() {
            return this.config.isCheckTimeEnabled() && System.currentTimeMillis() - this.lastCheckTime.get() >= this.checkTimeInterval;
        }

        int getTotalConnectionsUnderMonitor() {
            return this.connectionMap.size();
        }

        long getTotalProbesSentOnAllConnections() {
            Iterator connIterator = this.connectionMap.values().iterator();
            long totalProbeSent = 0L;
            while (connIterator.hasNext()) {
                MessageTransportBase mtb = (MessageTransportBase)connIterator.next();
                ConnectionHealthCheckerContextImpl connContext = (ConnectionHealthCheckerContextImpl)mtb.getHealthCheckerContext();
                totalProbeSent += connContext.getTotalProbesSent();
            }
            return totalProbeSent;
        }
    }
}

