/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.handler;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.ConfigurationContext;
import com.tc.object.ClientConfigurationContext;
import com.tc.object.context.PauseContext;
import com.tc.object.handshakemanager.ClientHandshakeManager;
import com.tc.object.msg.ClientHandshakeAckMessage;
import com.tc.object.msg.ClientHandshakeRefusedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCoordinationHandler<EC>
extends AbstractEventHandler<EC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientCoordinationHandler.class);
    private ClientHandshakeManager clientHandshakeManager;

    @Override
    public void handleEvent(EC context) {
        if (context instanceof ClientHandshakeRefusedMessage) {
            LOGGER.error(((ClientHandshakeRefusedMessage)context).getRefusalsCause());
            LOGGER.info("L1 Exiting...");
            throw new RuntimeException(((ClientHandshakeRefusedMessage)context).getRefusalsCause());
        }
        if (context instanceof ClientHandshakeAckMessage) {
            this.handleClientHandshakeAckMessage((ClientHandshakeAckMessage)context);
        } else if (context instanceof PauseContext) {
            this.handlePauseContext((PauseContext)context);
        } else {
            throw new AssertionError((Object)("unknown event type: " + context.getClass().getName()));
        }
    }

    private void handlePauseContext(PauseContext ctxt) {
        if (ctxt.getIsPause()) {
            this.clientHandshakeManager.disconnected();
        } else {
            this.clientHandshakeManager.connected();
        }
    }

    private void handleClientHandshakeAckMessage(ClientHandshakeAckMessage handshakeAck) {
        this.clientHandshakeManager.acknowledgeHandshake(handshakeAck);
    }

    @Override
    public synchronized void initialize(ConfigurationContext context) {
        super.initialize(context);
        ClientConfigurationContext ccContext = (ClientConfigurationContext)context;
        this.clientHandshakeManager = ccContext.getClientHandshakeManager();
    }
}

