/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.config;

import java.math.BigInteger;
import java.util.concurrent.TimeUnit;

public final class TimeoutDuration {
    private final long amount;
    private final TimeUnit unit;
    public static final TimeoutDuration NONE = new TimeoutDuration(Long.MAX_VALUE, TimeUnit.NANOSECONDS);

    private TimeoutDuration(long amount, TimeUnit unit) {
        this.amount = amount;
        this.unit = unit;
    }

    public static TimeoutDuration of(long amount, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("TimeoutDuration unit can not be null");
        }
        if (amount < 0L) {
            throw new IllegalArgumentException("TimeoutDuration time amount must be non-negative");
        }
        if (amount == TimeoutDuration.NONE.amount && unit == TimeoutDuration.NONE.unit) {
            return NONE;
        }
        return new TimeoutDuration(amount, unit);
    }

    public long toNanos() {
        return this.unit.toNanos(this.amount);
    }

    public long toMillis() {
        return this.unit.toMillis(this.amount);
    }

    public long convert(TimeUnit toUnit) {
        return toUnit.convert(this.amount, this.unit);
    }

    public void timedWait(Object obj) throws InterruptedException {
        this.unit.timedWait(obj, this.amount);
    }

    public boolean equals(Object other) {
        TimeoutDuration moreGranular;
        TimeoutDuration lessGranular;
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TimeoutDuration that = (TimeoutDuration)other;
        if (this.amount == 0L && that.amount == 0L) {
            return true;
        }
        if (this.unit == that.unit) {
            return this.amount == that.amount;
        }
        if (this.unit.convert(1L, that.unit) > 0L) {
            lessGranular = that;
            moreGranular = this;
        } else {
            lessGranular = this;
            moreGranular = that;
        }
        return BigInteger.valueOf(moreGranular.unit.convert(1L, lessGranular.unit)).multiply(BigInteger.valueOf(lessGranular.amount)).equals(BigInteger.valueOf(moreGranular.amount));
    }

    public int hashCode() {
        return BigInteger.valueOf(TimeUnit.NANOSECONDS.convert(1L, this.unit)).multiply(BigInteger.valueOf(this.amount)).hashCode();
    }

    public String toString() {
        return this == NONE ? "TimeoutDuration.NONE" : "TimeoutDuration{" + this.amount + ' ' + (Object)((Object)this.unit) + '}';
    }
}

