/*
 * Decompiled with CFR 0.152.
 */
package com.tcclient.cluster;

public class ClusterNodeStatus {
    private volatile ClusterNodeStateType state = ClusterNodeStateType.UNKNOWN;

    public void nodeJoined() {
        this.state = ClusterNodeStateType.NODE_JOINED;
    }

    public void operationsEnabled() {
        this.state = ClusterNodeStateType.OPERATIONS_ENABLED;
    }

    public void operationsDisabled() {
        this.state = ClusterNodeStateType.OPERATIONS_DISABLED;
    }

    public void nodeLeft() {
        this.state = ClusterNodeStateType.NODE_LEFT;
    }

    public ClusterNodeStateType getState() {
        return this.state;
    }

    public static enum ClusterNodeStateType {
        UNKNOWN("unknown", false, false, false),
        NODE_JOINED("node-joined", true, false, false),
        OPERATIONS_ENABLED("operations-enabled", true, true, false),
        OPERATIONS_DISABLED("operations-disabled", true, false, false),
        NODE_LEFT("node-left", true, false, true);

        private final String name;
        private final boolean nodeJoined;
        private final boolean opsEnabled;
        private final boolean nodeLeft;

        public String toString() {
            return "ClusterNodeState[name=" + this.name + "]";
        }

        private ClusterNodeStateType(String name, boolean nodeJoined, boolean opsEnabled, boolean nodeLeft) {
            this.name = name;
            this.nodeJoined = nodeJoined;
            this.opsEnabled = opsEnabled;
            this.nodeLeft = nodeLeft;
        }

        public boolean isNodeJoined() {
            return this.nodeJoined;
        }

        public boolean areOperationsEnabled() {
            return this.opsEnabled;
        }

        public boolean isNodeLeft() {
            return this.nodeLeft;
        }
    }
}

