/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store;

import java.util.Collections;
import java.util.Map;
import org.ehcache.clustered.client.internal.store.operations.Result;
import org.ehcache.clustered.common.internal.store.Chain;

public interface ResolvedChain<K, V> {
    public Chain getCompactedChain();

    public Result<V> getResolvedResult(K var1);

    public boolean isCompacted();

    public int getCompactionCount();

    public static class Impl<K, V>
    implements ResolvedChain<K, V> {
        private final Chain compactedChain;
        private final Map<K, Result<V>> resolvedOperations;
        private final int compactionCount;

        public Impl(Chain compactedChain, Map<K, Result<V>> resolvedOperations, int compactionCount) {
            this.compactedChain = compactedChain;
            this.resolvedOperations = resolvedOperations;
            this.compactionCount = compactionCount;
        }

        public Impl(Chain compactedChain, K key, Result<V> result, int compactedSize) {
            this(compactedChain, Collections.singletonMap(key, result), compactedSize);
        }

        @Override
        public Chain getCompactedChain() {
            return this.compactedChain;
        }

        @Override
        public Result<V> getResolvedResult(K key) {
            return this.resolvedOperations.get(key);
        }

        @Override
        public boolean isCompacted() {
            return this.compactionCount > 0;
        }

        @Override
        public int getCompactionCount() {
            return this.compactionCount;
        }
    }
}

