/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.service;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.ehcache.clustered.client.internal.service.ClusteredMapException;
import org.ehcache.clustered.client.internal.service.ValueCodec;
import org.ehcache.clustered.client.internal.service.ValueCodecFactory;
import org.ehcache.clustered.client.internal.store.ClusterTierClientEntity;
import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.StateRepositoryMessageFactory;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpMessage;
import org.ehcache.spi.persistence.StateHolder;

public class ClusteredStateHolder<K, V>
implements StateHolder<K, V> {
    private final StateRepositoryMessageFactory messageFactory;
    private final ClusterTierClientEntity entity;
    private final Class<K> keyClass;
    private final ValueCodec<K> keyCodec;
    private final ValueCodec<V> valueCodec;

    public ClusteredStateHolder(String cacheId, String mapId, ClusterTierClientEntity entity, Class<K> keyClass, Class<V> valueClass) {
        this.keyClass = keyClass;
        this.keyCodec = ValueCodecFactory.getCodecForClass(keyClass);
        this.valueCodec = ValueCodecFactory.getCodecForClass(valueClass);
        this.messageFactory = new StateRepositoryMessageFactory(cacheId, mapId, entity.getClientId());
        this.entity = entity;
    }

    public V get(Object key) {
        if (!this.keyClass.isAssignableFrom(key.getClass())) {
            return null;
        }
        Object response = this.getResponse(this.messageFactory.getMessage(this.keyCodec.encode(key)), false);
        return this.valueCodec.decode(response);
    }

    private Object getResponse(StateRepositoryOpMessage message, boolean track) {
        try {
            EhcacheEntityResponse response = this.entity.invokeStateRepositoryOperation(message, track);
            return ((EhcacheEntityResponse.MapValue)response).getValue();
        }
        catch (ClusterException ce) {
            throw new ClusteredMapException(ce);
        }
        catch (TimeoutException te) {
            throw new ClusteredMapException(te);
        }
    }

    public Set<Map.Entry<K, V>> entrySet() {
        Set response = (Set)this.getResponse(this.messageFactory.entrySetMessage(), true);
        HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry objectEntry : response) {
            entries.add(new AbstractMap.SimpleEntry<K, V>(this.keyCodec.decode(objectEntry.getKey()), this.valueCodec.decode(objectEntry.getValue())));
        }
        return entries;
    }

    public V putIfAbsent(K key, V value) {
        Object response = this.getResponse(this.messageFactory.putIfAbsentMessage(this.keyCodec.encode(key), this.valueCodec.encode(value)), true);
        return this.valueCodec.decode(response);
    }
}

