/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection.client;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class TerracottaClientConfigParams {
    private final List<String> stripeMembers;
    private boolean disableReconnect = false;
    private ClassLoader clasLoader;
    private final Properties properties = new Properties();

    public TerracottaClientConfigParams() {
        this.stripeMembers = new Vector<String>();
    }

    public List<String> getStripeMemberUris() {
        return Collections.unmodifiableList(this.stripeMembers);
    }

    public TerracottaClientConfigParams addStripeMemberUri(String stripeMember) {
        this.stripeMembers.add(stripeMember);
        return this;
    }

    public TerracottaClientConfigParams disableReconnect() {
        this.disableReconnect = true;
        return this;
    }

    public boolean isDisableReconnect() {
        return this.disableReconnect;
    }

    public ClassLoader getClassLoader() {
        return this.clasLoader;
    }

    public TerracottaClientConfigParams classLoader(ClassLoader loader) {
        this.setClassLoader(loader);
        return this;
    }

    public void setClassLoader(ClassLoader loader) {
        this.clasLoader = loader;
    }

    public void addGenericProperties(Properties props) {
        this.properties.putAll((Map<?, ?>)props);
    }

    public Properties getGenericProperties() {
        return this.properties;
    }
}

