/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.config;

import com.tc.config.schema.L2ConfigForL1;
import com.tc.logging.CustomerLogging;
import com.tc.logging.TCLogger;
import com.tc.net.core.ConnectionInfo;
import com.tc.net.core.SecurityInfo;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;

public class ConnectionInfoConfig {
    static TCLogger consoleLogger = CustomerLogging.getConsoleLogger();
    private final ConnectionInfo[] connectionInfos;

    public ConnectionInfoConfig(L2ConfigForL1.L2Data[] l2sData) {
        this(l2sData, new SecurityInfo());
    }

    public ConnectionInfoConfig(L2ConfigForL1.L2Data[] l2sData, SecurityInfo securityInfo) {
        this.connectionInfos = this.createValueFrom(l2sData, securityInfo);
    }

    private ConnectionInfo[] createValueFrom(L2ConfigForL1.L2Data[] l2sData, SecurityInfo securityInfo) {
        ConnectionInfo[] out;
        String serversProperty = System.getProperty("tc.server");
        if (serversProperty != null && (serversProperty = serversProperty.trim()) != null && serversProperty.length() > 0) {
            consoleLogger.info("tc.server: " + serversProperty);
            String[] serverDescs = serversProperty.split(",");
            int count = serverDescs.length;
            out = new ConnectionInfo[count];
            for (int i = 0; i < count; ++i) {
                String[] serverDesc = serverDescs[i].split(":");
                String host = serverDesc.length > 0 ? serverDesc[0] : "localhost";
                int tsaPort = 9410;
                if (serverDesc.length == 2) {
                    try {
                        tsaPort = Integer.parseInt(serverDesc[1]);
                    }
                    catch (NumberFormatException nfe) {
                        consoleLogger.warn("Cannot parse port for tc.server element '" + serverDescs[i] + "'; Using default of 9410.");
                    }
                }
                boolean secure = false;
                String urlUsername = null;
                int userSeparatorIndex = host.indexOf(64);
                if (userSeparatorIndex > -1) {
                    secure = true;
                    urlUsername = host.substring(0, userSeparatorIndex);
                    try {
                        urlUsername = URLDecoder.decode(urlUsername, "UTF-8");
                    }
                    catch (UnsupportedEncodingException uee) {
                        // empty catch block
                    }
                    host = host.substring(userSeparatorIndex + 1);
                }
                out[i] = new ConnectionInfo(host, tsaPort, new SecurityInfo(secure, urlUsername));
            }
        } else {
            out = new ConnectionInfo[l2sData.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = new ConnectionInfo(l2sData[i].host(), l2sData[i].tsaPort(), l2sData[i].getGroupId(), securityInfo);
            }
        }
        return out;
    }

    public ConnectionInfo[] getConnectionInfos() {
        return this.connectionInfos;
    }

    public String toString() {
        return "ConnectionInfoConfig [connectionInfos=" + Arrays.toString(this.connectionInfos) + "]";
    }
}

