/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.async.api.PostInit;
import com.tc.async.api.SEDA;
import com.tc.async.api.Sink;
import com.tc.async.api.Stage;
import com.tc.async.api.StageManager;
import com.tc.cluster.Cluster;
import com.tc.entity.DiagnosticMessageImpl;
import com.tc.entity.DiagnosticResponseImpl;
import com.tc.entity.NetworkVoltronEntityMessageImpl;
import com.tc.entity.ServerEntityMessageImpl;
import com.tc.entity.ServerEntityResponseMessageImpl;
import com.tc.entity.VoltronEntityAppliedResponseImpl;
import com.tc.entity.VoltronEntityMultiResponse;
import com.tc.entity.VoltronEntityMultiResponseImpl;
import com.tc.entity.VoltronEntityReceivedResponseImpl;
import com.tc.entity.VoltronEntityResponse;
import com.tc.entity.VoltronEntityRetiredResponseImpl;
import com.tc.exception.TCRuntimeException;
import com.tc.handler.CallbackDumpAdapter;
import com.tc.handler.CallbackDumpHandler;
import com.tc.lang.TCThreadGroup;
import com.tc.logging.CallbackOnExitHandler;
import com.tc.logging.CallbackOnExitState;
import com.tc.logging.ClientIDLogger;
import com.tc.logging.ClientIDLoggerProvider;
import com.tc.logging.CustomerLogging;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.management.TCClient;
import com.tc.net.CommStackMismatchException;
import com.tc.net.MaxConnectionsExceededException;
import com.tc.net.TCSocketAddress;
import com.tc.net.core.ConnectionInfo;
import com.tc.net.core.security.TCSecurityManager;
import com.tc.net.protocol.NetworkStackHarnessFactory;
import com.tc.net.protocol.PlainNetworkStackHarnessFactory;
import com.tc.net.protocol.delivery.OOONetworkStackHarnessFactory;
import com.tc.net.protocol.delivery.OnceAndOnlyOnceProtocolNetworkLayerFactoryImpl;
import com.tc.net.protocol.tcm.ChannelEvent;
import com.tc.net.protocol.tcm.ChannelEventListener;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.tcm.CommunicationsManager;
import com.tc.net.protocol.tcm.HydrateContext;
import com.tc.net.protocol.tcm.HydrateHandler;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.MessageMonitorImpl;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.net.protocol.tcm.TCMessageRouter;
import com.tc.net.protocol.tcm.TCMessageRouterImpl;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.transport.HealthCheckerConfigClientImpl;
import com.tc.net.protocol.transport.NullConnectionPolicy;
import com.tc.net.protocol.transport.ReconnectionRejectedHandlerL1;
import com.tc.net.protocol.transport.TransportHandshakeException;
import com.tc.object.ClientBuilder;
import com.tc.object.ClientConfigurationContext;
import com.tc.object.ClientEntityManager;
import com.tc.object.ClientNameProvider;
import com.tc.object.ClientShutdownManager;
import com.tc.object.StandardClientBuilder;
import com.tc.object.config.ClientConfig;
import com.tc.object.config.PreparedComponentsFromL2Connection;
import com.tc.object.context.PauseContext;
import com.tc.object.handler.ClientCoordinationHandler;
import com.tc.object.handler.ClusterInternalEventsHandler;
import com.tc.object.handler.ClusterMembershipEventsHandler;
import com.tc.object.handshakemanager.ClientHandshakeManager;
import com.tc.object.handshakemanager.ClientHandshakeManagerImpl;
import com.tc.object.msg.ClientHandshakeAckMessageImpl;
import com.tc.object.msg.ClientHandshakeMessageImpl;
import com.tc.object.msg.ClientHandshakeRefusedMessageImpl;
import com.tc.object.msg.ClusterMembershipMessage;
import com.tc.object.msg.InvokeRegisteredServiceMessage;
import com.tc.object.msg.InvokeRegisteredServiceResponseMessage;
import com.tc.object.msg.ListRegisteredServicesMessage;
import com.tc.object.msg.ListRegisteredServicesResponseMessage;
import com.tc.object.request.MultiRequestReceiveHandler;
import com.tc.object.request.RequestReceiveHandler;
import com.tc.object.servermessage.ServerMessageReceiveHandler;
import com.tc.object.session.SessionManagerImpl;
import com.tc.operatorevent.TerracottaOperatorEventLogging;
import com.tc.platform.rejoin.ClientChannelEventController;
import com.tc.properties.ReconnectConfig;
import com.tc.properties.TCProperties;
import com.tc.properties.TCPropertiesImpl;
import com.tc.stats.counter.CounterManager;
import com.tc.stats.counter.CounterManagerImpl;
import com.tc.stats.counter.sampled.SampledCounterConfig;
import com.tc.stats.counter.sampled.derived.SampledRateCounterConfig;
import com.tc.util.Assert;
import com.tc.util.CommonShutDownHook;
import com.tc.util.ProductID;
import com.tc.util.ProductInfo;
import com.tc.util.TCTimeoutException;
import com.tc.util.UUID;
import com.tc.util.concurrent.SetOnceFlag;
import com.tc.util.concurrent.SetOnceRef;
import com.tc.util.sequence.Sequence;
import com.tc.util.sequence.SimpleSequence;
import com.tcclient.cluster.ClusterInternal;
import com.tcclient.cluster.ClusterInternalEventsContext;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DistributedObjectClient
implements TCClient {
    protected static final TCLogger DSO_LOGGER = CustomerLogging.getDSOGenericLogger();
    private static final TCLogger CONSOLE_LOGGER = CustomerLogging.getConsoleLogger();
    private static final String L1VMShutdownHookName = "L1 VM Shutdown Hook";
    private final ClientBuilder clientBuilder;
    private final ClientConfig config;
    private final ClusterInternal cluster;
    private final TCThreadGroup threadGroup;
    protected final PreparedComponentsFromL2Connection connectionComponents;
    private ClientMessageChannel channel;
    private CommunicationsManager communicationsManager;
    private ClientHandshakeManager clientHandshakeManager;
    private CounterManager counterManager;
    private final CallbackDumpHandler dumpHandler = new CallbackDumpHandler();
    private Stage<ClusterInternalEventsContext> clusterEventsStage;
    private final TCSecurityManager securityManager;
    private final String uuid;
    private final String name;
    private ClientShutdownManager shutdownManager;
    private final Thread shutdownAction;
    private final SetOnceFlag clientStopped = new SetOnceFlag();
    private final SetOnceFlag connectionMade = new SetOnceFlag();
    private final SetOnceRef<Exception> exceptionMade = new SetOnceRef();
    private ClientEntityManager clientEntityManager;
    private final StageManager communicationStageManager;

    public DistributedObjectClient(ClientConfig config, TCThreadGroup threadGroup, PreparedComponentsFromL2Connection connectionComponents, ClusterInternal cluster) {
        this(config, new StandardClientBuilder(ProductID.PERMANENT), threadGroup, connectionComponents, cluster, null, UUID.NULL_ID.toString(), "");
    }

    public DistributedObjectClient(ClientConfig config, ClientBuilder builder, TCThreadGroup threadGroup, PreparedComponentsFromL2Connection connectionComponents, ClusterInternal cluster, TCSecurityManager securityManager, String uuid, String name) {
        Assert.assertNotNull(config);
        this.config = config;
        this.securityManager = securityManager;
        this.connectionComponents = connectionComponents;
        this.cluster = cluster;
        this.threadGroup = threadGroup;
        this.clientBuilder = builder;
        this.uuid = uuid;
        this.name = name;
        this.shutdownAction = new Thread((Runnable)new ShutdownAction(), L1VMShutdownHookName);
        Runtime.getRuntime().addShutdownHook(this.shutdownAction);
        SEDA seda = new SEDA(threadGroup);
        this.communicationStageManager = seda.getStageManager();
    }

    private void validateSecurityConfig() {
        if (this.config.getSecurityInfo().isSecure() && this.securityManager == null) {
            throw new TCRuntimeException("client configured as secure but was constructed without securityManager");
        }
        if (!this.config.getSecurityInfo().isSecure() && this.securityManager != null) {
            throw new TCRuntimeException("client not configured as secure but was constructed with securityManager");
        }
    }

    private ReconnectConfig getReconnectPropertiesFromServer() {
        ReconnectConfig reconnectConfig = new ReconnectConfig(){

            @Override
            public boolean getReconnectEnabled() {
                return false;
            }

            @Override
            public int getReconnectTimeout() {
                return 5000;
            }

            @Override
            public int getSendQueueCapacity() {
                return 5000;
            }

            @Override
            public int getMaxDelayAcks() {
                return 16;
            }

            @Override
            public int getSendWindow() {
                return 32;
            }
        };
        return reconnectConfig;
    }

    private NetworkStackHarnessFactory getNetworkStackHarnessFactory(boolean useOOOLayer, ReconnectConfig l1ReconnectConfig) {
        if (useOOOLayer) {
            return new OOONetworkStackHarnessFactory(new OnceAndOnlyOnceProtocolNetworkLayerFactoryImpl(), l1ReconnectConfig);
        }
        return new PlainNetworkStackHarnessFactory();
    }

    public Stage<ClusterInternalEventsContext> getClusterEventsStage() {
        return this.clusterEventsStage;
    }

    public synchronized void start() {
        String[] stringArray;
        this.validateSecurityConfig();
        TCProperties tcProperties = TCPropertiesImpl.getProperties();
        int maxSize = tcProperties.getInt("l1.seda.stage.sink.capacity");
        SessionManagerImpl sessionManager = new SessionManagerImpl(new SessionManagerImpl.SequenceFactory(){

            @Override
            public Sequence newSequence() {
                return new SimpleSequence();
            }
        });
        this.threadGroup.addCallbackOnExitDefaultHandler(new CallbackOnExitHandler(){

            @Override
            public void callbackOnExit(CallbackOnExitState state) {
                DistributedObjectClient.this.cluster.fireNodeError();
            }
        });
        this.dumpHandler.registerForDump(new CallbackDumpAdapter(this.communicationStageManager));
        ReconnectConfig l1ReconnectConfig = this.getReconnectPropertiesFromServer();
        boolean useOOOLayer = l1ReconnectConfig.getReconnectEnabled();
        NetworkStackHarnessFactory networkStackHarnessFactory = this.getNetworkStackHarnessFactory(useOOOLayer, l1ReconnectConfig);
        this.counterManager = new CounterManagerImpl();
        MessageMonitor mm = MessageMonitorImpl.createMonitor(tcProperties, DSO_LOGGER);
        TCMessageRouterImpl messageRouter = new TCMessageRouterImpl();
        HealthCheckerConfigClientImpl hc = new HealthCheckerConfigClientImpl(tcProperties.getPropertiesFor("l1.healthcheck.l2"), "TC Client");
        this.communicationsManager = this.clientBuilder.createCommunicationsManager(mm, messageRouter, networkStackHarnessFactory, new NullConnectionPolicy(), 1, hc, this.getMessageTypeClassMapping(), ReconnectionRejectedHandlerL1.SINGLETON, this.securityManager);
        DSO_LOGGER.debug("Created CommunicationsManager.");
        this.clusterEventsStage = this.communicationStageManager.createStage("cluster_events_stage", ClusterInternalEventsContext.class, new ClusterInternalEventsHandler(this.cluster), 1, maxSize);
        int socketConnectTimeout = tcProperties.getInt("l1.socket.connect.timeout");
        if (socketConnectTimeout < 0) {
            throw new IllegalArgumentException("invalid socket time value: " + socketConnectTimeout);
        }
        this.channel = this.clientBuilder.createClientMessageChannel(this.communicationsManager, sessionManager, socketConnectTimeout, this);
        this.channel.addListener(new ChannelEventListener(){

            @Override
            public void notifyChannelEvent(ChannelEvent event) {
                switch (event.getType()) {
                    case TRANSPORT_CLOSED_EVENT: 
                    case TRANSPORT_RECONNECTION_REJECTED_EVENT: {
                        DistributedObjectClient.this.shutdown();
                    }
                }
            }
        });
        ClientIDLoggerProvider cidLoggerProvider = new ClientIDLoggerProvider(this.channel);
        this.communicationStageManager.setLoggerProvider(cidLoggerProvider);
        DSO_LOGGER.debug("Created channel.");
        this.clientEntityManager = this.clientBuilder.createClientEntityManager(this.channel, this.communicationStageManager);
        RequestReceiveHandler receivingHandler = new RequestReceiveHandler(this.clientEntityManager);
        MultiRequestReceiveHandler mutil = new MultiRequestReceiveHandler(this.clientEntityManager);
        Stage<VoltronEntityResponse> entityResponseStage = this.communicationStageManager.createStage("request_ack_stage", VoltronEntityResponse.class, receivingHandler, 1, maxSize);
        Stage<VoltronEntityMultiResponse> multiResponseStage = this.communicationStageManager.createStage("multi_request_ack_stage", VoltronEntityMultiResponse.class, mutil, 1, maxSize);
        Stage<Void> serverMessageStage = this.communicationStageManager.createStage("server_entity_message_stage", Void.class, new ServerMessageReceiveHandler(this.channel), 1, maxSize);
        TerracottaOperatorEventLogging.setNodeNameProvider(new ClientNameProvider(this.cluster));
        SampledRateCounterConfig sampledRateCounterConfig = new SampledRateCounterConfig(1, 300, true);
        this.counterManager.createCounter(sampledRateCounterConfig);
        this.counterManager.createCounter(sampledRateCounterConfig);
        SampledCounterConfig sampledCounterConfig = new SampledCounterConfig(1, 300, true, 0L);
        this.counterManager.createCounter(sampledCounterConfig);
        this.threadGroup.addCallbackOnExitDefaultHandler(new CallbackDumpAdapter(this.clientEntityManager));
        this.dumpHandler.registerForDump(new CallbackDumpAdapter(this.clientEntityManager));
        Stage<HydrateContext> hydrateStage = this.communicationStageManager.createStage("hydrate_message_stage", HydrateContext.class, new HydrateHandler(), 1, maxSize);
        Stage<PauseContext> pauseStage = this.communicationStageManager.createStage("client_coordination_stage", PauseContext.class, new ClientCoordinationHandler(), 1, maxSize);
        Sink<PauseContext> pauseSink = pauseStage.getSink();
        Stage<Void> clusterMembershipEventStage = this.communicationStageManager.createStage("cluster_membership_event_stage", Void.class, new ClusterMembershipEventsHandler(this.cluster), 1, maxSize);
        ProductInfo pInfo = ProductInfo.getInstance();
        this.clientHandshakeManager = this.clientBuilder.createClientHandshakeManager(new ClientIDLogger(this.channel, TCLogging.getLogger(ClientHandshakeManagerImpl.class)), this.channel.getClientHandshakeMessageFactory(), sessionManager, this.cluster, this.uuid, this.name, pInfo.version(), this.clientEntityManager);
        ClientChannelEventController.connectChannelEventListener(this.channel, this.clientHandshakeManager);
        this.shutdownManager = new ClientShutdownManager(this, this.connectionComponents);
        ClientConfigurationContext cc = new ClientConfigurationContext(this.communicationStageManager, this.clientEntityManager, this.clientHandshakeManager);
        if (this.channel.getProductId() == ProductID.DIAGNOSTIC) {
            String[] stringArray2 = new String[5];
            stringArray2[0] = "cluster_events_stage";
            stringArray2[1] = "cluster_membership_event_stage";
            stringArray2[2] = "lock_response_stage";
            stringArray2[3] = "multi_request_ack_stage";
            stringArray = stringArray2;
            stringArray2[4] = "server_entity_message_stage";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "lock_response_stage";
        }
        String[] exclusion = stringArray;
        this.communicationStageManager.startAll(cc, Collections.<PostInit>emptyList(), exclusion);
        this.initChannelMessageRouter(messageRouter, hydrateStage.getSink(), pauseSink, clusterMembershipEventStage.getSink(), entityResponseStage.getSink(), multiResponseStage.getSink(), serverMessageStage.getSink());
        new Thread(this.threadGroup, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!DistributedObjectClient.this.clientStopped.isSet()) {
                    try {
                        DistributedObjectClient.this.openChannel();
                        DistributedObjectClient.this.waitForHandshake();
                        DistributedObjectClient.this.connectionMade();
                    }
                    catch (RuntimeException runtime) {
                        SetOnceFlag setOnceFlag = DistributedObjectClient.this.connectionMade;
                        synchronized (setOnceFlag) {
                            DistributedObjectClient.this.exceptionMade.set(runtime);
                            DistributedObjectClient.this.connectionMade.notifyAll();
                        }
                    }
                    catch (InterruptedException ie) {
                        SetOnceFlag setOnceFlag = DistributedObjectClient.this.connectionMade;
                        synchronized (setOnceFlag) {
                            DistributedObjectClient.this.exceptionMade.set(ie);
                            DistributedObjectClient.this.connectionMade.notifyAll();
                        }
                    }
                }
            }
        }, "Connection Maker - " + this.uuid).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionMade() {
        this.connectionMade.attemptSet();
        SetOnceFlag setOnceFlag = this.connectionMade;
        synchronized (setOnceFlag) {
            this.connectionMade.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForConnection(long timeout, TimeUnit units) throws InterruptedException {
        SetOnceFlag setOnceFlag = this.connectionMade;
        synchronized (setOnceFlag) {
            long start;
            for (long left = timeout > 0L ? units.toMillis(timeout) : Long.MAX_VALUE; !this.connectionMade.isSet() && !this.exceptionMade.isSet() && left > 0L; left -= System.currentTimeMillis() - start) {
                start = System.currentTimeMillis();
                this.connectionMade.wait(units.toMillis(timeout));
            }
        }
        if (this.exceptionMade.isSet()) {
            Exception exp = this.exceptionMade.get();
            throw new RuntimeException(exp);
        }
        return this.connectionMade.isSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openChannel() throws InterruptedException {
        List<ConnectionInfo> infos = Arrays.asList(this.connectionComponents.createConnectionInfoConfigItem().getConnectionInfos());
        if (infos.isEmpty()) {
            return;
        }
        ConnectionInfo info = (ConnectionInfo)infos.iterator().next();
        String hostname = info.getHostname();
        int port = info.getPort();
        SetOnceFlag setOnceFlag = this.clientStopped;
        synchronized (setOnceFlag) {
            while (!this.clientStopped.isSet()) {
                try {
                    char[] pw;
                    String username;
                    DSO_LOGGER.debug("Trying to open channel....");
                    if (this.config.getSecurityInfo().hasCredentials()) {
                        Assert.assertNotNull(this.securityManager);
                        username = this.config.getSecurityInfo().getUsername();
                        pw = this.securityManager.getPasswordForTC(this.config.getSecurityInfo().getUsername(), hostname, port);
                    } else {
                        pw = null;
                        username = null;
                    }
                    this.channel.open(infos, username, pw);
                    DSO_LOGGER.debug("Channel open");
                    break;
                }
                catch (TCTimeoutException tcte) {
                    CONSOLE_LOGGER.warn("Timeout connecting to server: " + tcte.getMessage());
                    this.clientStopped.wait(5000L);
                }
                catch (ConnectException e) {
                    CONSOLE_LOGGER.warn("Connection refused from server: " + e);
                    this.clientStopped.wait(5000L);
                }
                catch (MaxConnectionsExceededException e) {
                    DSO_LOGGER.fatal(e.getMessage());
                    CONSOLE_LOGGER.fatal(e.getMessage());
                    throw new IllegalStateException(e.getMessage(), e);
                }
                catch (CommStackMismatchException e) {
                    DSO_LOGGER.fatal(e.getMessage());
                    CONSOLE_LOGGER.fatal(e.getMessage());
                    throw new IllegalStateException(e.getMessage(), e);
                }
                catch (TransportHandshakeException handshake) {
                    DSO_LOGGER.fatal(handshake.getMessage());
                    CONSOLE_LOGGER.fatal(handshake.getMessage());
                    throw new IllegalStateException(handshake.getMessage(), handshake);
                }
                catch (IOException ioe) {
                    CONSOLE_LOGGER.warn("IOException connecting to server: " + hostname + ":" + port + ". " + ioe.getMessage());
                    this.clientStopped.wait(5000L);
                }
            }
        }
    }

    private void waitForHandshake() {
        this.clientHandshakeManager.waitForHandshake();
        if (this.channel != null) {
            TCSocketAddress remoteAddress = this.channel.getRemoteAddress();
            String infoMsg = "Connection successfully established to server at " + remoteAddress;
            CONSOLE_LOGGER.info(infoMsg);
        }
    }

    private Map<TCMessageType, Class<? extends TCMessage>> getMessageTypeClassMapping() {
        HashMap<TCMessageType, Class<? extends TCMessage>> messageTypeClassMapping = new HashMap<TCMessageType, Class<? extends TCMessage>>();
        messageTypeClassMapping.put(TCMessageType.CLIENT_HANDSHAKE_MESSAGE, ClientHandshakeMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.CLIENT_HANDSHAKE_ACK_MESSAGE, ClientHandshakeAckMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.CLIENT_HANDSHAKE_REFUSED_MESSAGE, ClientHandshakeRefusedMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.CLUSTER_MEMBERSHIP_EVENT_MESSAGE, ClusterMembershipMessage.class);
        messageTypeClassMapping.put(TCMessageType.LIST_REGISTERED_SERVICES_MESSAGE, ListRegisteredServicesMessage.class);
        messageTypeClassMapping.put(TCMessageType.LIST_REGISTERED_SERVICES_RESPONSE_MESSAGE, ListRegisteredServicesResponseMessage.class);
        messageTypeClassMapping.put(TCMessageType.INVOKE_REGISTERED_SERVICE_MESSAGE, InvokeRegisteredServiceMessage.class);
        messageTypeClassMapping.put(TCMessageType.INVOKE_REGISTERED_SERVICE_RESPONSE_MESSAGE, InvokeRegisteredServiceResponseMessage.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_MESSAGE, NetworkVoltronEntityMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_RECEIVED_RESPONSE, VoltronEntityReceivedResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_COMPLETED_RESPONSE, VoltronEntityAppliedResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_RETIRED_RESPONSE, VoltronEntityRetiredResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.VOLTRON_ENTITY_MULTI_RESPONSE, VoltronEntityMultiResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.DIAGNOSTIC_REQUEST, DiagnosticMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.DIAGNOSTIC_RESPONSE, DiagnosticResponseImpl.class);
        messageTypeClassMapping.put(TCMessageType.SERVER_ENTITY_MESSAGE, ServerEntityMessageImpl.class);
        messageTypeClassMapping.put(TCMessageType.SERVER_ENTITY_RESPONSE_MESSAGE, ServerEntityResponseMessageImpl.class);
        return messageTypeClassMapping;
    }

    private void initChannelMessageRouter(TCMessageRouter messageRouter, Sink<HydrateContext> hydrateSink, Sink<PauseContext> pauseSink, Sink<Void> clusterMembershipEventSink, Sink<VoltronEntityResponse> responseSink, Sink<VoltronEntityMultiResponse> multiSink, Sink<Void> serverEntityMessageSink) {
        messageRouter.routeMessageType(TCMessageType.CLIENT_HANDSHAKE_ACK_MESSAGE, pauseSink, hydrateSink);
        messageRouter.routeMessageType(TCMessageType.CLIENT_HANDSHAKE_REFUSED_MESSAGE, pauseSink, hydrateSink);
        messageRouter.routeMessageType(TCMessageType.CLIENT_HANDSHAKE_REDIRECT_MESSAGE, pauseSink, hydrateSink);
        messageRouter.routeMessageType(TCMessageType.CLUSTER_MEMBERSHIP_EVENT_MESSAGE, clusterMembershipEventSink, hydrateSink);
        messageRouter.routeMessageType(TCMessageType.VOLTRON_ENTITY_RECEIVED_RESPONSE, responseSink, hydrateSink);
        messageRouter.routeMessageType(TCMessageType.VOLTRON_ENTITY_COMPLETED_RESPONSE, responseSink, hydrateSink);
        messageRouter.routeMessageType(TCMessageType.VOLTRON_ENTITY_RETIRED_RESPONSE, responseSink, hydrateSink);
        messageRouter.routeMessageType(TCMessageType.VOLTRON_ENTITY_MULTI_RESPONSE, multiSink, hydrateSink);
        messageRouter.routeMessageType(TCMessageType.DIAGNOSTIC_RESPONSE, responseSink, hydrateSink);
        messageRouter.routeMessageType(TCMessageType.SERVER_ENTITY_MESSAGE, serverEntityMessageSink, hydrateSink);
        DSO_LOGGER.debug("Added message routing types.");
    }

    public ClientEntityManager getEntityManager() {
        return this.clientEntityManager;
    }

    public CommunicationsManager getCommunicationsManager() {
        return this.communicationsManager;
    }

    public ClientMessageChannel getChannel() {
        return this.channel;
    }

    public ClientHandshakeManager getClientHandshakeManager() {
        return this.clientHandshakeManager;
    }

    @Override
    public void dump() {
        this.dumpHandler.dump();
    }

    protected ClientConfig getClientConfigHelper() {
        return this.config;
    }

    public void shutdown() {
        this.shutdown(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownResources() {
        TCLogger logger = DSO_LOGGER;
        if (this.counterManager != null) {
            try {
                this.counterManager.shutdown();
            }
            catch (Throwable t) {
                logger.error("error shutting down counter manager", t);
            }
            finally {
                this.counterManager = null;
            }
        }
        try {
            this.communicationStageManager.stopAll();
        }
        catch (Throwable t) {
            logger.error("Error stopping stage manager", t);
        }
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Throwable t) {
                logger.error("Error closing channel", t);
            }
            finally {
                this.channel = null;
            }
        }
        if (this.communicationsManager != null) {
            try {
                this.communicationsManager.shutdown();
            }
            catch (Throwable t) {
                logger.error("Error shutting down communications manager", t);
            }
            finally {
                this.communicationsManager = null;
            }
        }
        CommonShutDownHook.shutdown();
        this.cluster.shutdown();
        if (this.threadGroup != null) {
            boolean interrupted = false;
            try {
                long end = System.currentTimeMillis() + TCPropertiesImpl.getProperties().getLong("l1.shutdown.threadgroup.gracetime");
                int threadCount = this.threadGroup.activeCount();
                Thread[] t = new Thread[threadCount];
                threadCount = this.threadGroup.enumerate(t);
                long time = System.currentTimeMillis();
                for (int x = 0; x < threadCount; ++x) {
                    long start = System.currentTimeMillis();
                    while (System.currentTimeMillis() < end && t[x].isAlive()) {
                        t[x].join(1000L);
                    }
                    logger.debug("Destroyed thread " + t[x].getName() + " time to destroy:" + (System.currentTimeMillis() - start) + " millis");
                }
                logger.debug("time to destroy thread group:" + TimeUnit.SECONDS.convert(System.currentTimeMillis() - time, TimeUnit.MILLISECONDS) + " seconds");
                if (this.threadGroup.activeCount() > 0) {
                    logger.warn("Timed out waiting for TC thread group threads to die - probable shutdown memory leak\nLive threads: " + DistributedObjectClient.getLiveThreads(this.threadGroup));
                    Thread threadGroupCleanerThread = new Thread(this.threadGroup.getParent(), new TCThreadGroupCleanerRunnable(this.threadGroup), "TCThreadGroup last chance cleaner thread");
                    threadGroupCleanerThread.setDaemon(true);
                    threadGroupCleanerThread.start();
                    logger.warn("Spawning TCThreadGroup last chance cleaner thread");
                } else {
                    logger.debug("Destroying TC thread group");
                    this.threadGroup.destroy();
                }
            }
            catch (Throwable t) {
                logger.error("Error destroying TC thread group", t);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (TCPropertiesImpl.getProperties().getBoolean("l1.shutdown.force.finalization")) {
            System.runFinalization();
        }
    }

    private static List<Thread> getLiveThreads(ThreadGroup group) {
        int estimate = group.activeCount();
        Thread[] threads = new Thread[estimate + 1];
        while (true) {
            int count;
            if ((count = group.enumerate(threads)) < threads.length) {
                ArrayList<Thread> l = new ArrayList<Thread>(count);
                for (Thread t : threads) {
                    if (t == null) continue;
                    l.add(t);
                }
                return l;
            }
            threads = new Thread[threads.length * 2];
        }
    }

    @Override
    public String[] processArguments() {
        return null;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownClient(boolean fromShutdownHook, boolean forceImmediate) {
        if (this.shutdownManager != null) {
            try {
                this.shutdownManager.execute(fromShutdownHook, forceImmediate);
            }
            finally {
                if (Thread.currentThread() != this.shutdownAction) {
                    try {
                        Runtime.getRuntime().removeShutdownHook(this.shutdownAction);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown(boolean fromShutdownHook, boolean forceImmediate) {
        if (this.clientStopped.attemptSet()) {
            SetOnceFlag setOnceFlag = this.clientStopped;
            synchronized (setOnceFlag) {
                this.clientStopped.notifyAll();
            }
            DSO_LOGGER.info("shutting down Terracotta Client hook=" + fromShutdownHook + " force=" + forceImmediate);
            this.shutdownClient(fromShutdownHook, forceImmediate);
        } else {
            DSO_LOGGER.info("Client already shutdown.");
        }
    }

    private class ShutdownAction
    implements Runnable {
        private ShutdownAction() {
        }

        @Override
        public void run() {
            DSO_LOGGER.info("Running L1 VM shutdown hook");
            DistributedObjectClient.this.shutdown(true, false);
        }
    }

    private static class TCThreadGroupCleanerRunnable
    implements Runnable {
        private final TCThreadGroup threadGroup;

        public TCThreadGroupCleanerRunnable(TCThreadGroup threadGroup) {
            this.threadGroup = threadGroup;
        }

        @Override
        public void run() {
            while (this.threadGroup.activeCount() > 0) {
                for (Thread liveThread : DistributedObjectClient.getLiveThreads(this.threadGroup)) {
                    liveThread.interrupt();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
            try {
                this.threadGroup.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

