/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.exception.TCRuntimeException;
import com.tc.logging.ConnectionIdLogger;
import com.tc.logging.TCLogging;
import com.tc.net.CommStackMismatchException;
import com.tc.net.MaxConnectionsExceededException;
import com.tc.net.ReconnectionRejectedException;
import com.tc.net.TCSocketAddress;
import com.tc.net.core.ConnectionInfo;
import com.tc.net.core.TCConnection;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.core.event.TCConnectionEvent;
import com.tc.net.core.security.TCSecurityManager;
import com.tc.net.protocol.NetworkStackID;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.TCProtocolAdaptor;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.MessageTransportBase;
import com.tc.net.protocol.transport.MessageTransportListener;
import com.tc.net.protocol.transport.MessageTransportState;
import com.tc.net.protocol.transport.MessageTransportStatus;
import com.tc.net.protocol.transport.NoActiveException;
import com.tc.net.protocol.transport.ReconnectionRejectedHandler;
import com.tc.net.protocol.transport.ReconnectionRejectedHandlerL1;
import com.tc.net.protocol.transport.SynAckMessage;
import com.tc.net.protocol.transport.TransportHandshakeError;
import com.tc.net.protocol.transport.TransportHandshakeErrorContext;
import com.tc.net.protocol.transport.TransportHandshakeErrorHandler;
import com.tc.net.protocol.transport.TransportHandshakeException;
import com.tc.net.protocol.transport.TransportHandshakeMessage;
import com.tc.net.protocol.transport.TransportHandshakeMessageFactory;
import com.tc.net.protocol.transport.TransportRedirect;
import com.tc.net.protocol.transport.WireProtocolAdaptorFactory;
import com.tc.net.protocol.transport.WireProtocolMessage;
import com.tc.net.protocol.transport.WireProtocolMessageSink;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Assert;
import com.tc.util.TCTimeoutException;
import com.tc.util.concurrent.TCExceptionResultException;
import com.tc.util.concurrent.TCFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClientMessageTransport
extends MessageTransportBase {
    public static final long TRANSPORT_HANDSHAKE_SYNACK_TIMEOUT = TCPropertiesImpl.getProperties().getLong("tc.transport.handshake.timeout", 10000L);
    private final TCConnectionManager connectionManager;
    private boolean wasOpened = false;
    private TCFuture waitForSynAckResult;
    private final WireProtocolAdaptorFactory wireProtocolAdaptorFactory;
    private final AtomicBoolean isOpening = new AtomicBoolean(false);
    private final int callbackPort;
    private final int timeout;
    private final TCSecurityManager securityManager;
    private ConnectionInfo connectionInfo;

    public ClientMessageTransport(TCConnectionManager clientConnectionEstablisher, TransportHandshakeErrorHandler handshakeErrorHandler, TransportHandshakeMessageFactory messageFactory, WireProtocolAdaptorFactory wireProtocolAdaptorFactory, int callbackPort, int timeout) {
        this(clientConnectionEstablisher, handshakeErrorHandler, messageFactory, wireProtocolAdaptorFactory, callbackPort, timeout, ReconnectionRejectedHandlerL1.SINGLETON, null);
    }

    public ClientMessageTransport(TCConnectionManager connectionManager, TransportHandshakeErrorHandler handshakeErrorHandler, TransportHandshakeMessageFactory messageFactory, WireProtocolAdaptorFactory wireProtocolAdaptorFactory, int callbackPort, int timeout, ReconnectionRejectedHandler reconnectionRejectedHandler, TCSecurityManager securityManager) {
        super(MessageTransportState.STATE_START, handshakeErrorHandler, messageFactory, false, TCLogging.getLogger(ClientMessageTransport.class));
        this.wireProtocolAdaptorFactory = wireProtocolAdaptorFactory;
        this.connectionManager = connectionManager;
        this.callbackPort = callbackPort;
        this.timeout = timeout;
        this.securityManager = securityManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkStackID open(ConnectionInfo info) throws TCTimeoutException, IOException, MaxConnectionsExceededException, CommStackMismatchException {
        this.isOpening.set(true);
        AtomicBoolean atomicBoolean = this.isOpen;
        synchronized (atomicBoolean) {
            Assert.eval("can't open an already open transport", !this.isOpen.get());
            Assert.eval("can't open an already connected transport", !this.isConnected());
            TCSocketAddress socket = new TCSocketAddress(info);
            TCConnection connection = this.connect(socket);
            try {
                this.openConnection(connection);
            }
            catch (CommStackMismatchException e) {
                connection.close(100L);
                throw e;
            }
            catch (MaxConnectionsExceededException e) {
                connection.close(100L);
                throw e;
            }
            catch (TCTimeoutException e) {
                connection.close(100L);
                throw e;
            }
            catch (TransportHandshakeException e) {
                connection.close(100L);
                throw e;
            }
            Assert.eval(!this.getConnectionId().isNull());
            this.isOpen.set(true);
            NetworkStackID nid = new NetworkStackID(this.getConnectionId().getChannelID());
            this.wasOpened = true;
            this.isOpening.set(false);
            return nid;
        }
    }

    TCConnection connect(TCSocketAddress sa) throws TCTimeoutException, IOException {
        TCConnection connection = this.connectionManager.createConnection(this.getProtocolAdapter());
        this.fireTransportConnectAttemptEvent();
        try {
            connection.connect(sa, this.timeout);
        }
        catch (IOException e) {
            connection.close(100L);
            throw e;
        }
        catch (TCTimeoutException e) {
            connection.close(100L);
            throw e;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        AtomicBoolean atomicBoolean = this.isOpen;
        synchronized (atomicBoolean) {
            this.getLogger().info("Resetting connection " + this.getConnectionId());
            this.disconnect();
            this.isOpen.set(false);
            this.status.reset();
            this.clearConnection();
        }
    }

    private void handleHandshakeError(HandshakeResult result) throws TransportHandshakeException, MaxConnectionsExceededException, CommStackMismatchException, ReconnectionRejectedException {
        if (result.hasErrorContext()) {
            switch (result.getError()) {
                case ERROR_NO_ACTIVE: {
                    if (!this.getConnectionId().getProductId().isRedirectEnabled()) break;
                    throw new NoActiveException();
                }
                case ERROR_MAX_CONNECTION_EXCEED: {
                    this.cleanConnectionWithoutNotifyListeners();
                    throw new MaxConnectionsExceededException(this.getMaxConnectionsExceededMessage(result.maxConnections()));
                }
                case ERROR_STACK_MISMATCH: {
                    this.cleanConnectionWithoutNotifyListeners();
                    throw new CommStackMismatchException("Disconnected due to comm stack mismatch");
                }
                case ERROR_RECONNECTION_REJECTED: {
                    this.cleanConnectionWithoutNotifyListeners();
                    this.fireTransportReconnectionRejectedEvent();
                    throw new ReconnectionRejectedException("Reconnection rejected by L2 due to stack not found. Client will be unable to join the cluster again unless rejoin is enabled.");
                }
                case ERROR_REDIRECT_CONNECTION: {
                    if (!this.getConnectionId().getProductId().isRedirectEnabled()) break;
                    throw new TransportRedirect(result.synAck.getErrorContext());
                }
                default: {
                    throw new TransportHandshakeException("Disconnected due to transport handshake error: " + (Object)((Object)result.getError()));
                }
            }
        }
    }

    private void cleanConnectionWithoutNotifyListeners() {
        ArrayList<MessageTransportListener> tl = new ArrayList<MessageTransportListener>(this.getTransportListeners());
        this.removeTransportListeners();
        this.clearConnection();
        this.addTransportListeners(tl);
        this.status.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasOpened() {
        AtomicBoolean atomicBoolean = this.isOpen;
        synchronized (atomicBoolean) {
            return this.wasOpened;
        }
    }

    public boolean isNotOpen() {
        return !this.isOpening.get() && !this.isOpen.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeEvent(TCConnectionEvent event) {
        if (this.isNotOpen()) {
            return;
        }
        super.closeEvent(event);
        MessageTransportStatus messageTransportStatus = this.status;
        synchronized (messageTransportStatus) {
            if (this.waitForSynAckResult != null) {
                this.waitForSynAckResult.setException(new IOException("connection closed"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void receiveTransportMessageImpl(WireProtocolMessage message) {
        MessageTransportStatus messageTransportStatus = this.status;
        synchronized (messageTransportStatus) {
            if (this.status.isSynSent()) {
                this.handleSynAck(message);
                message.recycle();
                return;
            }
            if (!this.status.isEstablished()) {
                this.getLogger().warn("Ignoring the message received for an Un-Established Connection; " + message.getSource() + "; " + message);
                message.recycle();
                return;
            }
        }
        super.receiveToReceiveLayer(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSynAck(WireProtocolMessage message) {
        if (!this.verifySynAck(message)) {
            this.handleHandshakeError(new TransportHandshakeErrorContext("Received a message that was not a SYN_ACK while waiting for SYN_ACK: " + message, TransportHandshakeError.ERROR_HANDSHAKE));
        } else {
            SynAckMessage synAck = (SynAckMessage)message;
            if (synAck.hasErrorContext()) {
                if (synAck.getErrorType() == TransportHandshakeError.ERROR_STACK_MISMATCH) {
                    this.handleHandshakeError(new TransportHandshakeErrorContext(this.getCommsStackMismatchErrorMessage(synAck) + "\n\nPLEASE RECONFIGURE THE STACKS", synAck.getErrorType()));
                } else {
                    this.handleHandshakeError(new TransportHandshakeErrorContext(synAck.getErrorContext() + message, synAck.getErrorType()));
                }
            }
            if (!this.getConnectionId().isNewConnection() && this.getConnectionId().isValid()) {
                Assert.eval(!synAck.getConnectionId().isValid() || this.getConnectionId().equals(synAck.getConnectionId()));
            }
            if (!synAck.isMaxConnectionsExceeded()) {
                if (!this.getConnectionId().isValid()) {
                    this.initConnectionID(synAck.getConnectionId());
                }
                Assert.assertNotNull("Connection id from the server was null!", this.getConnectionId());
                Assert.eval(!ConnectionID.NULL_ID.equals(this.getConnectionId()));
                Assert.assertNotNull(this.waitForSynAckResult);
            }
            this.getConnection().setTransportEstablished();
            MessageTransportStatus messageTransportStatus = this.status;
            synchronized (messageTransportStatus) {
                this.waitForSynAckResult.set(synAck);
                this.waitForSynAckResult = null;
            }
            this.setRemoteCallbackPort(synAck.getCallbackPort());
        }
    }

    private String getCommsStackMismatchErrorMessage(SynAckMessage synAck) {
        String errorMessage = "\n\nLayers Present in Client side communication stack: ";
        errorMessage = errorMessage + this.getCommunicationStackNames(this);
        errorMessage = "\nTHERE IS A MISMATCH IN THE COMMUNICATION STACKS\n" + synAck.getErrorContext() + errorMessage;
        if ((this.getCommunicationStackFlags(this) & 2) != 0) {
            this.getLogger().error("Once and Only Once Protocol Layer is present in client but not in server");
            errorMessage = "\n\nOnce and Only Once Protocol Layer is present in client but not in server" + errorMessage;
        } else {
            this.getLogger().error("Once and Only Once Protocol Layer is present in server but not in client");
            errorMessage = "\n\nOnce and Only Once Protocol Layer is present in server but not in client" + errorMessage;
        }
        return errorMessage;
    }

    private boolean verifySynAck(TCNetworkMessage message) {
        return message instanceof TransportHandshakeMessage && ((TransportHandshakeMessage)message).isSynAck();
    }

    HandshakeResult handShake() throws TCTimeoutException, TransportHandshakeException {
        try {
            SynAckMessage synAck = (SynAckMessage)this.sendSyn().get(TRANSPORT_HANDSHAKE_SYNACK_TIMEOUT);
            return new HandshakeResult(synAck);
        }
        catch (InterruptedException e) {
            throw new TransportHandshakeException(e);
        }
        catch (TCExceptionResultException e) {
            throw new TransportHandshakeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCFuture sendSyn() {
        TCFuture targetFuture = new TCFuture(this.status);
        this.getConnection().addWeight(1);
        MessageTransportStatus messageTransportStatus = this.status;
        synchronized (messageTransportStatus) {
            if (this.status.isEstablished() || this.status.isSynSent()) {
                throw new AssertionError((Object)(" ERROR !!! " + this.status));
            }
            this.waitForSynAckResult = targetFuture;
            short stackLayerFlags = this.getCommunicationStackFlags(this);
            if (this.getConnectionId().isSecured() && this.getConnectionId().getPassword() == null) {
                this.getConnectionId().setPassword(this.securityManager.getPasswordForTC(this.getConnectionId().getUsername(), this.connectionInfo.getHostname(), this.connectionInfo.getPort()));
            }
            TransportHandshakeMessage syn = this.messageFactory.createSyn(this.getConnectionId(), this.getConnection(), stackLayerFlags, this.callbackPort);
            try {
                this.sendToConnection(syn);
                this.status.synSent();
            }
            catch (IOException ioe) {
                this.logger.warn("trouble syn", ioe);
            }
        }
        return targetFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAck() throws TransportHandshakeException {
        MessageTransportStatus messageTransportStatus = this.status;
        synchronized (messageTransportStatus) {
            if (!this.status.isSynSent()) {
                throw new TransportHandshakeException("Transport is not " + (Object)((Object)MessageTransportState.STATE_SYN_SENT) + ". Status: " + this.status);
            }
            TransportHandshakeMessage ack = this.messageFactory.createAck(this.getConnectionId(), this.getConnection());
            try {
                this.sendToConnection(ack);
            }
            catch (IOException ioe) {
                throw new TransportHandshakeException(ioe);
            }
            this.status.established();
        }
        this.fireTransportConnectedEvent();
    }

    protected void openConnection(TCConnection connection) throws TCTimeoutException, TransportHandshakeException, MaxConnectionsExceededException, CommStackMismatchException {
        Assert.eval(!this.isConnected());
        if (this.wireNewConnection(connection)) {
            try {
                this.handshakeConnection();
            }
            catch (TCTimeoutException e) {
                this.clearConnection();
                this.status.reset();
                throw e;
            }
            catch (ReconnectionRejectedException e) {
                throw new TCRuntimeException("Should not happen here: " + e);
            }
            catch (TransportHandshakeException e) {
                this.clearConnection();
                this.status.reset();
                throw e;
            }
        } else {
            throw new TransportHandshakeException("connection closed");
        }
    }

    void reopen(ConnectionInfo info) throws Exception {
        if (!this.wasOpened()) {
            this.getLogger().warn("Transport was opened already. Skip reconnect " + info);
            return;
        }
        TCSocketAddress socket = new TCSocketAddress(info);
        this.reconnect(socket);
    }

    void reconnect(TCSocketAddress socket) throws Exception {
        TCConnection connection = this.connect(socket);
        Assert.eval(!this.isConnected());
        if (this.wireNewConnection(connection)) {
            try {
                this.handshakeConnection();
            }
            catch (Exception t) {
                connection.close(100L);
                this.status.reset();
                throw t;
            }
        }
    }

    private void handshakeConnection() throws TCTimeoutException, MaxConnectionsExceededException, TransportHandshakeException, CommStackMismatchException, ReconnectionRejectedException {
        HandshakeResult result = this.handShake();
        this.handleHandshakeError(result);
        this.sendAck();
        this.getConnectionId().authenticated();
    }

    private String getMaxConnectionsExceededMessage(int maxConnections) {
        return "Your product key only allows maximum " + maxConnections + " clients to connect.";
    }

    TCProtocolAdaptor getProtocolAdapter() {
        return this.wireProtocolAdaptorFactory.newWireProtocolAdaptor(new WireProtocolMessageSink(){

            @Override
            public void putMessage(WireProtocolMessage message) {
                ClientMessageTransport.this.receiveTransportMessage(message);
            }
        });
    }

    @Override
    protected void fireTransportConnectAttemptEvent() {
        super.fireTransportConnectAttemptEvent();
    }

    @Override
    public boolean isConnected() {
        return super.isConnected();
    }

    public void switchLoggerForTesting(ConnectionIdLogger tmpLogger) {
        this.logger = tmpLogger;
    }

    @Override
    public void sendToConnection(TCNetworkMessage message) throws IOException {
        super.sendToConnection(message);
    }

    private static final class HandshakeResult {
        private final SynAckMessage synAck;

        private HandshakeResult(SynAckMessage synAck) {
            this.synAck = synAck;
        }

        public int maxConnections() {
            return this.synAck.getMaxConnections();
        }

        public boolean hasErrorContext() {
            return this.synAck.isMaxConnectionsExceeded() || this.synAck.hasErrorContext();
        }

        public boolean isConnectionValid() {
            return this.synAck.getConnectionId().isValid();
        }

        public TransportHandshakeError getError() {
            if (this.synAck.isMaxConnectionsExceeded()) {
                return TransportHandshakeError.ERROR_MAX_CONNECTION_EXCEED;
            }
            return this.synAck.getErrorType();
        }
    }
}

