/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.net;

import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.TCSocketAddress;
import com.tc.net.core.TCConnection;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.ChannelManager;
import com.tc.net.protocol.tcm.ChannelManagerEventListener;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageChannelInternal;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.msg.ClientHandshakeAckMessage;
import com.tc.object.msg.ClientHandshakeRefusedMessage;
import com.tc.object.net.DSOChannelManager;
import com.tc.object.net.DSOChannelManagerEventListener;
import com.tc.object.net.DSOChannelManagerMBean;
import com.tc.object.net.NoSuchChannelException;
import com.tc.util.concurrent.CopyOnWriteSequentialMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class DSOChannelManagerImpl
implements DSOChannelManager,
DSOChannelManagerMBean {
    private static final TCLogger logger = TCLogging.getLogger(DSOChannelManager.class);
    private final CopyOnWriteSequentialMap<NodeID, MessageChannel> activeChannels = new CopyOnWriteSequentialMap(new CopyOnWriteSequentialMap.TypedArrayFactory(){

        public MessageChannel[] createTypedArray(int size) {
            return new MessageChannel[size];
        }
    });
    private final List<DSOChannelManagerEventListener> eventListeners = new CopyOnWriteArrayList<DSOChannelManagerEventListener>();
    private final ChannelManager genericChannelManager;
    private final TCConnectionManager connectionManager;
    private final String serverVersion;

    public DSOChannelManagerImpl(ChannelManager genericChannelManager, TCConnectionManager connectionManager, String serverVersion) {
        this.genericChannelManager = genericChannelManager;
        this.genericChannelManager.addEventListener(new GenericChannelEventListener());
        this.serverVersion = serverVersion;
        this.connectionManager = connectionManager;
    }

    @Override
    public MessageChannel getActiveChannel(NodeID id) throws NoSuchChannelException {
        MessageChannel rv = this.activeChannels.get(id);
        if (rv == null) {
            throw new NoSuchChannelException("No such channel: " + id);
        }
        return rv;
    }

    @Override
    public void closeAll(Collection<? extends NodeID> clientIDs) {
        for (NodeID nodeID : clientIDs) {
            if (nodeID instanceof ClientID) {
                ClientID id = (ClientID)nodeID;
                MessageChannelInternal channel = this.genericChannelManager.getChannel(new ChannelID(id.toLong()));
                if (channel == null) continue;
                channel.close();
                continue;
            }
            logger.info("Ignoring close for " + nodeID);
        }
    }

    @Override
    public MessageChannel[] getActiveChannels() {
        return (MessageChannel[])this.activeChannels.valuesToArray();
    }

    @Override
    public boolean isActiveID(NodeID nodeID) {
        return this.activeChannels.containsKey(nodeID);
    }

    @Override
    public String getChannelAddress(NodeID nid) {
        try {
            MessageChannel channel = this.getActiveChannel(nid);
            TCSocketAddress addr = channel.getRemoteAddress();
            return addr.getStringForm();
        }
        catch (NoSuchChannelException e) {
            return "no longer connected";
        }
    }

    private ClientHandshakeRefusedMessage newClientHandshakeRefusedMessage(ClientID clientID) throws NoSuchChannelException {
        MessageChannelInternal channel = this.genericChannelManager.getChannel(new ChannelID(clientID.toLong()));
        if (channel == null) {
            throw new NoSuchChannelException();
        }
        return (ClientHandshakeRefusedMessage)channel.createMessage(TCMessageType.CLIENT_HANDSHAKE_REFUSED_MESSAGE);
    }

    private ClientHandshakeAckMessage newClientHandshakeAckMessage(ClientID clientID) throws NoSuchChannelException {
        MessageChannelInternal channel = this.genericChannelManager.getChannel(new ChannelID(clientID.toLong()));
        if (channel == null) {
            throw new NoSuchChannelException();
        }
        return (ClientHandshakeAckMessage)channel.createMessage(TCMessageType.CLIENT_HANDSHAKE_ACK_MESSAGE);
    }

    @Override
    public TCConnection[] getAllActiveClientConnections() {
        return this.connectionManager.getAllActiveConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeChannelActive(ClientID clientID) {
        try {
            ClientHandshakeAckMessage ackMsg = this.newClientHandshakeAckMessage(clientID);
            MessageChannel channel = ackMsg.getChannel();
            CopyOnWriteSequentialMap<NodeID, MessageChannel> copyOnWriteSequentialMap = this.activeChannels;
            synchronized (copyOnWriteSequentialMap) {
                this.activeChannels.put(clientID, channel);
                ackMsg.initialize(this.getAllActiveClientIDs(), clientID, this.serverVersion);
                if (!ackMsg.send()) {
                    logger.warn("Not sending handshake message to disconnected client: " + clientID);
                }
            }
            this.fireChannelCreatedEvent(channel);
        }
        catch (NoSuchChannelException nsce) {
            logger.warn("Not sending handshake message to disconnected client: " + clientID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeChannelRefuse(ClientID clientID, String message) {
        try {
            ClientHandshakeRefusedMessage handshakeRefuseMsg = this.newClientHandshakeRefusedMessage(clientID);
            CopyOnWriteSequentialMap<NodeID, MessageChannel> copyOnWriteSequentialMap = this.activeChannels;
            synchronized (copyOnWriteSequentialMap) {
                handshakeRefuseMsg.initialize(message);
                if (!handshakeRefuseMsg.send()) {
                    logger.warn("Not sending handshake rejected message to disconnected client: " + clientID);
                }
            }
        }
        catch (NoSuchChannelException nsce) {
            logger.warn("Not sending handshake rejected message to disconnected client: " + clientID);
        }
    }

    private Set<? extends NodeID> getAllActiveClientIDs() {
        HashSet<NodeID> clientIDs = new HashSet<NodeID>();
        for (NodeID cid : this.activeChannels.keySet()) {
            clientIDs.add(cid);
        }
        return clientIDs;
    }

    @Override
    public void makeChannelActiveNoAck(MessageChannel channel) {
        this.activeChannels.put(this.getClientIDFor(channel.getChannelID()), channel);
    }

    @Override
    public void addEventListener(DSOChannelManagerEventListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener cannot be be null");
        }
        this.eventListeners.add(listener);
    }

    @Override
    public Set<NodeID> getAllClientIDs() {
        Set<ChannelID> channelIDs = this.genericChannelManager.getAllChannelIDs();
        HashSet<NodeID> clientIDs = new HashSet<NodeID>(channelIDs.size());
        for (ChannelID cid : channelIDs) {
            clientIDs.add(this.getClientIDFor(cid));
        }
        return clientIDs;
    }

    private void fireChannelCreatedEvent(MessageChannel channel) {
        for (DSOChannelManagerEventListener eventListener : this.eventListeners) {
            eventListener.channelCreated(channel);
        }
    }

    private void fireChannelRemovedEvent(MessageChannel channel) {
        boolean isActive = this.isActiveID(channel.getRemoteNodeID());
        for (DSOChannelManagerEventListener eventListener : this.eventListeners) {
            eventListener.channelRemoved(channel, isActive);
        }
    }

    @Override
    public ClientID getClientIDFor(ChannelID channelID) {
        return new ClientID(channelID.toLong());
    }

    private class GenericChannelEventListener
    implements ChannelManagerEventListener {
        private GenericChannelEventListener() {
        }

        @Override
        public void channelCreated(MessageChannel channel) {
        }

        @Override
        public void channelRemoved(MessageChannel channel) {
            DSOChannelManagerImpl.this.fireChannelRemovedEvent(channel);
            DSOChannelManagerImpl.this.activeChannels.remove(DSOChannelManagerImpl.this.getClientIDFor(channel.getChannelID()));
        }
    }
}

