/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.impl;

import com.tc.async.api.EventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.async.api.Source;
import com.tc.async.api.SpecializedEventContext;
import com.tc.async.api.StageQueueStats;
import com.tc.async.impl.ContextWrapper;
import com.tc.logging.TCLogger;
import java.util.concurrent.atomic.AtomicInteger;

public class AbstractStageQueueImpl<EC> {

    static class HandledContext<C>
    implements ContextWrapper<C> {
        private final C context;

        public HandledContext(C context) {
            this.context = context;
        }

        @Override
        public void runWithHandler(EventHandler<C> handler) throws EventHandlerException {
            handler.handleEvent(this.context);
        }

        public boolean equals(Object obj) {
            if (this.context.getClass().isInstance(obj)) {
                return this.context.equals(obj);
            }
            return super.equals(obj);
        }
    }

    static class DirectExecuteContext<EC>
    implements ContextWrapper<EC> {
        private final SpecializedEventContext context;

        public DirectExecuteContext(SpecializedEventContext context) {
            this.context = context;
        }

        @Override
        public void runWithHandler(EventHandler<EC> handler) throws EventHandlerException {
            this.context.execute();
        }
    }

    static class StageQueueStatsCollectorImpl
    extends StageQueueStatsCollector {
        private final AtomicInteger count = new AtomicInteger(0);
        private final String name;
        private final String trimmedName;

        public StageQueueStatsCollectorImpl(String stage) {
            this.trimmedName = stage.trim();
            this.name = this.makeWidth(stage, 40);
        }

        @Override
        public String getDetails() {
            return this.name + " : " + this.count;
        }

        @Override
        public void contextAdded() {
            this.count.incrementAndGet();
        }

        @Override
        public void contextRemoved() {
            this.count.decrementAndGet();
        }

        @Override
        public void reset() {
            this.count.set(0);
        }

        @Override
        public String getName() {
            return this.trimmedName;
        }

        @Override
        public int getDepth() {
            return this.count.get();
        }
    }

    static class NullStageQueueStatsCollector
    extends StageQueueStatsCollector {
        private final String name;
        private final String trimmedName;

        public NullStageQueueStatsCollector(String stage) {
            this.trimmedName = stage.trim();
            this.name = this.makeWidth(stage, 40);
        }

        @Override
        public String getDetails() {
            return this.name + " : Not Monitored";
        }

        @Override
        public void contextAdded() {
        }

        @Override
        public void contextRemoved() {
        }

        @Override
        public void reset() {
        }

        @Override
        public String getName() {
            return this.trimmedName;
        }

        @Override
        public int getDepth() {
            return -1;
        }
    }

    static abstract class StageQueueStatsCollector
    implements StageQueueStats {
        StageQueueStatsCollector() {
        }

        @Override
        public void logDetails(TCLogger statsLogger) {
            statsLogger.info(this.getDetails());
        }

        public abstract void contextAdded();

        public abstract void reset();

        public abstract void contextRemoved();

        protected String makeWidth(String name, int width) {
            int len = name.length();
            if (len == width) {
                return name;
            }
            if (len > width) {
                return name.substring(0, width);
            }
            StringBuffer buf = new StringBuffer(name);
            for (int i = len; i < width; ++i) {
                buf.append(' ');
            }
            return buf.toString();
        }
    }

    static interface SourceQueue<W>
    extends Source<W> {
        public StageQueueStatsCollector getStatsCollector();

        public void setStatsCollector(StageQueueStatsCollector var1);

        public int clear();

        @Override
        public boolean isEmpty();

        @Override
        public W poll(long var1) throws InterruptedException;

        public void put(W var1) throws InterruptedException;

        public int size();

        @Override
        public String getSourceName();
    }
}

