/*
 * Decompiled with CFR 0.152.
 */
package com.tc.text;

import com.tc.text.ParagraphFormatter;
import com.tc.text.StringFormatter;
import java.util.Arrays;
import java.util.List;

public class ConsoleParagraphFormatter
implements ParagraphFormatter {
    private final StringFormatter sf;
    private final int maxWidth;

    public ConsoleParagraphFormatter(int maxWidth, StringFormatter stringFormatter) {
        this.maxWidth = maxWidth;
        this.sf = stringFormatter;
    }

    @Override
    public String format(String in) {
        StringBuffer buf = new StringBuffer();
        if (in == null) {
            throw new AssertionError();
        }
        List<String> words = this.parseWords(in);
        int lineWidth = 0;
        for (String currentWord : words) {
            if (lineWidth + currentWord.length() > this.maxWidth) {
                if (lineWidth > 0) {
                    buf.append(this.sf.newline());
                }
                lineWidth = currentWord.length();
            } else {
                if (lineWidth > 0) {
                    buf.append(" ");
                }
                lineWidth += currentWord.length();
            }
            buf.append(currentWord);
        }
        return buf.toString();
    }

    private List<String> parseWords(String in) {
        String[] words = in.split("\\s+");
        return Arrays.asList(words);
    }
}

