/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol;

import com.tc.bytes.TCByteBuffer;
import com.tc.exception.TCInternalError;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.protocol.TCNetworkHeader;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.util.Assert;
import com.tc.util.HexDump;
import com.tc.util.StringUtil;
import com.tc.util.concurrent.SetOnceFlag;

public class AbstractTCNetworkMessage
implements TCNetworkMessage {
    protected static final TCLogger logger = TCLogging.getLogger(TCNetworkMessage.class);
    private static final int MESSAGE_DUMP_MAXBYTES = 4096;
    private final SetOnceFlag sealed = new SetOnceFlag();
    private final SetOnceFlag sentCallbackFired = new SetOnceFlag();
    private static final TCByteBuffer[] EMPTY_BUFFER_ARRAY = new TCByteBuffer[0];
    private final TCNetworkHeader header;
    private TCByteBuffer[] payloadData;
    private TCNetworkMessage messagePayload;
    private TCByteBuffer[] entireMessageData;
    private int totalLength;
    private int dataLength;
    private int headerLength;
    private Runnable sentCallback = null;

    protected AbstractTCNetworkMessage(TCNetworkHeader header, boolean seal) {
        this(header, null, null, seal);
    }

    protected AbstractTCNetworkMessage(TCNetworkHeader header, TCNetworkMessage msgPayload) {
        this(header, msgPayload, null, true);
    }

    protected AbstractTCNetworkMessage(TCNetworkHeader header, TCByteBuffer[] payload) {
        this(header, null, payload, true);
    }

    private AbstractTCNetworkMessage(TCNetworkHeader header, TCNetworkMessage msgPayload, TCByteBuffer[] payload, boolean seal) {
        Assert.eval(header != null);
        this.header = header;
        this.messagePayload = msgPayload;
        TCByteBuffer[] tCByteBufferArray = this.payloadData = payload == null ? EMPTY_BUFFER_ARRAY : payload;
        if (msgPayload != null) {
            this.payloadData = msgPayload.getEntireMessageData();
        }
        if (seal) {
            this.seal();
        }
    }

    @Override
    public final int getDataLength() {
        this.checkSealed();
        return this.dataLength;
    }

    @Override
    public final int getHeaderLength() {
        this.checkSealed();
        return this.headerLength;
    }

    @Override
    public final int getTotalLength() {
        this.checkSealed();
        return this.totalLength;
    }

    @Override
    public final TCNetworkHeader getHeader() {
        this.checkNotRecycled();
        return this.header;
    }

    @Override
    public final TCNetworkMessage getMessagePayload() {
        this.checkNotRecycled();
        return this.messagePayload;
    }

    @Override
    public final TCByteBuffer[] getPayload() {
        this.checkNotRecycled();
        return this.payloadData;
    }

    protected final void setPayload(TCByteBuffer[] newPayload) {
        this.checkNotSealed();
        this.entireMessageData = null;
        this.payloadData = newPayload == null ? EMPTY_BUFFER_ARRAY : newPayload;
    }

    protected final void setMessagePayload(TCNetworkMessage subMessage) {
        this.checkNotSealed();
        this.entireMessageData = null;
        if (subMessage == null) {
            this.payloadData = EMPTY_BUFFER_ARRAY;
            this.messagePayload = null;
        } else {
            if (!subMessage.isSealed()) {
                throw new IllegalStateException("Message paylaod is not yet sealed");
            }
            this.messagePayload = subMessage;
            this.payloadData = subMessage.getEntireMessageData();
        }
    }

    @Override
    public final TCByteBuffer[] getEntireMessageData() {
        this.checkSealed();
        Assert.eval(this.entireMessageData != null);
        return this.entireMessageData;
    }

    public final String toString() {
        try {
            return this.toString0();
        }
        catch (Exception e) {
            logger.warn("Exception in toString()", e);
            return "EXCEPTION in toString(): " + e.getMessage();
        }
    }

    protected final String toString0() {
        StringBuffer buf = new StringBuffer();
        buf.append("Message Class: ").append(this.getClass().getName()).append("\n");
        buf.append("Sealed: ").append(this.sealed.isSet()).append(", ");
        buf.append("Header Length: ").append(this.getHeaderLength()).append(", ");
        buf.append("Data Length: ").append(this.getDataLength()).append(", ");
        buf.append("Total Length: ").append(this.getTotalLength()).append("\n");
        String extraMsgInfo = this.describeMessage();
        if (extraMsgInfo != null) {
            buf.append(extraMsgInfo);
        }
        if (this.header != null) {
            buf.append("Header (").append(this.header.getClass().getName()).append(")\n");
            buf.append(StringUtil.indentLines(this.header.toString()));
            if (buf.charAt(buf.length() - 1) != '\n') {
                buf.append('\n');
            }
        }
        buf.append("Payload:\n");
        if (this.messagePayload != null) {
            buf.append(StringUtil.indentLines(this.messagePayload.toString())).append("\n");
        } else if (this.payloadData != null) {
            buf.append(StringUtil.indentLines(this.describePayload()));
        } else {
            buf.append(StringUtil.indentLines("*** No payoad data ***\n"));
        }
        return buf.toString();
    }

    protected String describeMessage() {
        return null;
    }

    protected String describePayload() {
        StringBuffer buf = new StringBuffer();
        int totalBytesDumped = 0;
        if (this.payloadData != null && this.payloadData.length != 0) {
            for (int i = 0; i < this.payloadData.length; ++i) {
                buf.append("Buffer ").append(i).append(": ");
                if (this.payloadData[i] != null) {
                    buf.append(this.payloadData[i].toString());
                    buf.append("\n");
                    if (totalBytesDumped >= 4096) continue;
                    int bytesFullBuf = this.payloadData[i].limit();
                    int bytesToDump = totalBytesDumped + bytesFullBuf < 4096 ? bytesFullBuf : 4096 - totalBytesDumped;
                    buf.append(HexDump.dump(this.payloadData[i].array(), this.payloadData[i].arrayOffset(), bytesToDump));
                    totalBytesDumped += bytesToDump;
                    continue;
                }
                buf.append("null");
            }
        } else {
            buf.append("No payload buffers present");
        }
        return buf.toString();
    }

    protected String dump() {
        StringBuffer toRet = new StringBuffer(this.toString());
        toRet.append("\n\n");
        if (this.entireMessageData != null) {
            for (int i = 0; i < this.entireMessageData.length; ++i) {
                byte[] ba;
                toRet.append('[').append(i).append(']').append('=').append(this.entireMessageData[i].toString());
                toRet.append(" =  { ");
                for (byte element : ba = this.entireMessageData[i].array()) {
                    toRet.append(Byte.toString(element)).append(' ');
                }
                toRet.append(" }  \n\n");
            }
        }
        return toRet.toString();
    }

    @Override
    public final boolean isSealed() {
        return this.sealed.isSet();
    }

    @Override
    public final void seal() {
        long dataLen;
        if (this.sealed.attemptSet()) {
            int size = 1 + this.payloadData.length;
            this.entireMessageData = new TCByteBuffer[size];
            this.entireMessageData[0] = this.header.getDataBuffer();
            System.arraycopy(this.payloadData, 0, this.entireMessageData, 1, this.payloadData.length);
            dataLen = 0L;
            for (int i = 1; i < this.entireMessageData.length; ++i) {
                dataLen += (long)this.entireMessageData[i].limit();
            }
            if (dataLen > Integer.MAX_VALUE) {
                throw new TCInternalError("Message too big");
            }
        } else {
            throw new IllegalStateException("Message is sealed");
        }
        this.dataLength = (int)dataLen;
        this.headerLength = this.header.getHeaderByteLength();
        this.totalLength = this.headerLength + this.dataLength;
    }

    @Override
    public final void wasSent() {
        this.fireSentCallback();
        this.doRecycleOnWrite();
    }

    public void doRecycleOnWrite() {
        this.recycle();
    }

    @Override
    public void recycle() {
        if (this.entireMessageData != null) {
            int i = 0;
            if (this.entireMessageData.length > 1 && this.entireMessageData[0].array() == this.entireMessageData[1].array()) {
                ++i;
            }
            while (i < this.entireMessageData.length) {
                this.entireMessageData[i].recycle();
                ++i;
            }
            this.entireMessageData = null;
        } else {
            logger.warn("Entire Message is null ! Probably recycle was called twice ! ");
            Thread.dumpStack();
        }
    }

    protected boolean isRecycled() {
        return this.isSealed() && this.entireMessageData == null;
    }

    private void fireSentCallback() {
        if (this.sentCallback != null && this.sentCallbackFired.attemptSet()) {
            try {
                this.sentCallback.run();
            }
            catch (Exception e) {
                logger.error("Caught exception running sent callback", e);
            }
        }
    }

    @Override
    public final void setSentCallback(Runnable callback) {
        this.sentCallback = callback;
    }

    @Override
    public final Runnable getSentCallback() {
        return this.sentCallback;
    }

    private void checkNotRecycled() {
        if (this.isRecycled()) {
            throw new IllegalStateException("Message is already Recycled");
        }
    }

    private void checkSealed() {
        if (!this.isSealed()) {
            throw new IllegalStateException("Message is not sealed");
        }
    }

    private void checkNotSealed() {
        if (this.sealed.isSet()) {
            throw new IllegalStateException("Message is sealed");
        }
    }
}

