/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityID;
import java.io.IOException;

public class EntityDescriptor
implements TCSerializable<EntityDescriptor> {
    public static final long INVALID_VERSION = 0L;
    public static final EntityDescriptor NULL_ID = new EntityDescriptor(EntityID.NULL_ID, ClientInstanceID.NULL_ID, 0L);
    private final EntityID entityID;
    private final ClientInstanceID clientInstanceID;
    private final long clientSideVersion;

    public EntityDescriptor(EntityID entityID, ClientInstanceID clientInstanceID, long clientSideVersion) {
        this.entityID = entityID;
        this.clientInstanceID = clientInstanceID;
        this.clientSideVersion = clientSideVersion;
    }

    public EntityID getEntityID() {
        return this.entityID;
    }

    public ClientInstanceID getClientInstanceID() {
        return this.clientInstanceID;
    }

    public long getClientSideVersion() {
        return this.clientSideVersion;
    }

    public int hashCode() {
        return this.entityID.hashCode() ^ this.clientInstanceID.hashCode();
    }

    public boolean equals(Object other) {
        boolean doesMatch;
        boolean bl = doesMatch = this == other;
        if (!doesMatch && this.getClass() == other.getClass()) {
            EntityDescriptor that = (EntityDescriptor)other;
            doesMatch = this.entityID.equals(that.entityID) && this.clientInstanceID.equals(that.clientInstanceID);
        }
        return doesMatch;
    }

    @Override
    public void serializeTo(TCByteBufferOutput serialOutput) {
        this.entityID.serializeTo(serialOutput);
        this.clientInstanceID.serializeTo(serialOutput);
        serialOutput.writeLong(this.clientSideVersion);
    }

    @Override
    public EntityDescriptor deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        return EntityDescriptor.readFrom(serialInput);
    }

    public static EntityDescriptor readFrom(TCByteBufferInput serialInput) throws IOException {
        return new EntityDescriptor(EntityID.readFrom(serialInput), ClientInstanceID.readFrom(serialInput), serialInput.readLong());
    }

    public String toString() {
        return "EntityDescriptor{entityID=" + this.entityID + ", clientInstanceID=" + this.clientInstanceID + '}';
    }
}

