/*
 * Decompiled with CFR 0.152.
 */
package com.tc.logging;

import com.tc.logging.NullTCLoggingService;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLoggingService;
import java.net.URI;
import java.util.Iterator;
import java.util.ServiceLoader;

public class TCLogging {
    private static TCLoggingService service = new NullTCLoggingService();

    public static TCLogger getLogger(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        return TCLogging.getLogger(clazz.getName());
    }

    public static TCLogger getLogger(String name) {
        if (name == null) {
            throw new NullPointerException("Logger cannot be null");
        }
        return service.getLogger(name);
    }

    public static TCLogger getTestingLogger(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        return service.getTestingLogger(name);
    }

    public static TCLogger getTestingLogger(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        return TCLogging.getTestingLogger(clazz.getName());
    }

    static TCLogger getCustomerLogger(String name) {
        return service.getCustomerLogger(name);
    }

    static TCLogger getConsoleLogger() {
        return service.getConsoleLogger();
    }

    static TCLogger getOperatorEventLogger() {
        return service.getOperatorEventLogger();
    }

    public static TCLogger getDumpLogger() {
        return service.getDumpLogger();
    }

    public static void setLogLocationAndType(URI logLocation, ProcessType processType) {
        service.setLogLocationAndType(logLocation, processType.ordinal());
    }

    public static void setLoggingService(TCLoggingService service) {
        TCLogging.service = service;
    }

    public static TCLoggingService getLoggingService() {
        return service;
    }

    static {
        ServiceLoader<TCLoggingService> loader = ServiceLoader.load(TCLoggingService.class);
        Iterator<TCLoggingService> i$ = loader.iterator();
        while (i$.hasNext()) {
            TCLoggingService possible;
            service = possible = i$.next();
        }
    }

    public static enum ProcessType {
        GENERIC,
        CLIENT,
        SERVER;

    }
}

