/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.msg;

import com.tc.net.NodeID;
import com.tc.util.concurrent.SetOnceFlag;

public abstract class ReplicationIntent {
    private final NodeID dest;
    private final Runnable droppedWithoutSend;
    private final Runnable sent;
    private final SetOnceFlag handled = new SetOnceFlag();

    protected ReplicationIntent(NodeID dest, Runnable sent, Runnable droppedWithoutSend) {
        this.dest = dest;
        this.sent = sent;
        this.droppedWithoutSend = droppedWithoutSend;
    }

    public NodeID getDestination() {
        return this.dest;
    }

    public void sent() {
        this.handled.set();
        if (this.sent != null) {
            this.sent.run();
        }
    }

    public void droppedWithoutSend() {
        this.handled.set();
        if (this.droppedWithoutSend != null) {
            this.droppedWithoutSend.run();
        }
    }

    public boolean wasSentOrDropped() {
        return this.handled.isSet();
    }
}

