/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.locks;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import com.tc.net.NodeID;
import com.tc.net.groups.NodeIDSerializer;
import com.tc.object.locks.LockID;
import com.tc.object.locks.LockIDSerializer;
import com.tc.object.locks.ServerLockContext;
import com.tc.object.locks.ThreadID;
import java.io.IOException;

public class ClientServerExchangeLockContext
implements TCSerializable<ClientServerExchangeLockContext> {
    private static final ServerLockContext.State[] STATE_VALUES = ServerLockContext.State.values();
    private LockID lockID;
    private NodeID nodeID;
    private ThreadID threadID;
    private ServerLockContext.State state;
    private long timeout;

    public ClientServerExchangeLockContext() {
    }

    public ClientServerExchangeLockContext(LockID lockID, NodeID nodeID, ThreadID threadID, ServerLockContext.State state) {
        this(lockID, nodeID, threadID, state, -1L);
    }

    public ClientServerExchangeLockContext(LockID lockID, NodeID nodeID, ThreadID threadID, ServerLockContext.State state, long timeout) {
        this.lockID = lockID;
        this.nodeID = nodeID;
        this.threadID = threadID;
        this.state = state;
        this.timeout = timeout;
    }

    public NodeID getNodeID() {
        return this.nodeID;
    }

    public LockID getLockID() {
        return this.lockID;
    }

    public ServerLockContext.State getState() {
        return this.state;
    }

    public ThreadID getThreadID() {
        return this.threadID;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientServerExchangeLockContext)) {
            return false;
        }
        ClientServerExchangeLockContext cmp = (ClientServerExchangeLockContext)o;
        return this.lockID.equals(cmp.lockID) && this.threadID.equals(cmp.threadID) && this.state.equals((Object)cmp.state) && this.nodeID.equals(cmp.nodeID);
    }

    public int hashCode() {
        return 11 * this.lockID.hashCode() ^ 7 * this.threadID.hashCode() ^ 3 * this.state.hashCode() ^ 13 * this.nodeID.hashCode();
    }

    @Override
    public void serializeTo(TCByteBufferOutput output) {
        LockIDSerializer ls = new LockIDSerializer(this.lockID);
        ls.serializeTo(output);
        NodeIDSerializer ns = new NodeIDSerializer(this.nodeID);
        ns.serializeTo(output);
        output.writeLong(this.threadID.toLong());
        output.writeInt(this.state.ordinal());
        if (this.state.getType() == ServerLockContext.Type.WAITER || this.state.getType() == ServerLockContext.Type.TRY_PENDING) {
            output.writeLong(this.timeout);
        }
    }

    @Override
    public ClientServerExchangeLockContext deserializeFrom(TCByteBufferInput input) throws IOException {
        LockIDSerializer ls = new LockIDSerializer();
        ls.deserializeFrom(input);
        this.lockID = ls.getLockID();
        NodeIDSerializer ns = new NodeIDSerializer();
        ns.deserializeFrom(input);
        this.nodeID = ns.getNodeID();
        this.threadID = new ThreadID(input.readLong());
        this.state = STATE_VALUES[input.readInt()];
        this.timeout = this.state.getType() == ServerLockContext.Type.WAITER || this.state.getType() == ServerLockContext.Type.TRY_PENDING ? input.readLong() : -1L;
        return this;
    }

    public long timeout() {
        return this.timeout;
    }

    public String toString() {
        return "ClientServerExchangeLockContext [lockID=" + this.lockID + ", nodeID=" + this.nodeID + ", state=" + (Object)((Object)this.state) + ", threadID=" + this.threadID + "]";
    }
}

