/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.dna.impl;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class UTF8ByteDataHolder
implements Serializable {
    private static final int HASH_SEED = 1704124966;
    private static final int FNV_32_PRIME = 16777619;
    private final byte[] bytes;

    public UTF8ByteDataHolder(String str) {
        try {
            this.bytes = str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public UTF8ByteDataHolder(byte[] b) {
        this.bytes = b;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String asString() {
        return this.getString();
    }

    private String getString() {
        try {
            return new String(this.bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        return this.asString();
    }

    public int hashCode() {
        return this.computeHashCode(1704124966);
    }

    protected int computeHashCode(int init) {
        int hash = init;
        for (byte b : this.bytes) {
            hash ^= b;
            hash *= 16777619;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UTF8ByteDataHolder) {
            UTF8ByteDataHolder other = (UTF8ByteDataHolder)obj;
            return Arrays.equals(this.bytes, other.bytes) && this.getClass().equals(other.getClass());
        }
        return false;
    }
}

