/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.msg;

import com.tc.async.api.OrderedEventContext;
import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.net.ClientID;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.tx.TransactionID;
import com.tc.util.Assert;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class SyncReplicationActivity
implements OrderedEventContext {
    private ActivityID id;
    EntityDescriptor descriptor;
    ClientID src;
    TransactionID tid;
    TransactionID oldest;
    ActivityType action;
    byte[] payload;
    int concurrency;
    String debugId;

    public static SyncReplicationActivity createFlushLocalPipelineMessage(EntityID eid, long version) {
        return new SyncReplicationActivity(ActivityID.getNextID(), new EntityDescriptor(eid, ClientInstanceID.NULL_ID, version), ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, ActivityType.FLUSH_LOCAL_PIPELINE, null, 0, "");
    }

    public static SyncReplicationActivity createOrderingPlaceholder(EntityDescriptor descriptor, ClientID src, TransactionID tid, TransactionID oldest, String debugId) {
        return new SyncReplicationActivity(ActivityID.getNextID(), descriptor, src, tid, oldest, ActivityType.ORDERING_PLACEHOLDER, null, 0, debugId);
    }

    public static SyncReplicationActivity createReplicatedMessage(EntityDescriptor descriptor, ClientID src, TransactionID tid, TransactionID oldest, ActivityType action, byte[] payload, int concurrency, String debugId) {
        Assert.assertTrue(ActivityType.FLUSH_LOCAL_PIPELINE != action);
        Assert.assertTrue(ActivityType.ORDERING_PLACEHOLDER != action);
        Assert.assertTrue(ActivityType.SYNC_BEGIN != action);
        Assert.assertTrue(ActivityType.SYNC_END != action);
        Assert.assertTrue(ActivityType.SYNC_ENTITY_BEGIN != action);
        Assert.assertTrue(ActivityType.SYNC_ENTITY_END != action);
        Assert.assertTrue(ActivityType.SYNC_ENTITY_CONCURRENCY_BEGIN != action);
        Assert.assertTrue(ActivityType.SYNC_ENTITY_CONCURRENCY_END != action);
        Assert.assertTrue(ActivityType.SYNC_ENTITY_CONCURRENCY_PAYLOAD != action);
        Assert.assertTrue(ActivityType.SYNC_START != action);
        return new SyncReplicationActivity(ActivityID.getNextID(), descriptor, src, tid, oldest, action, payload, concurrency, debugId);
    }

    public static SyncReplicationActivity createStartSyncMessage() {
        return new SyncReplicationActivity(ActivityID.getNextID(), EntityDescriptor.NULL_ID, ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, ActivityType.SYNC_BEGIN, null, 0, "");
    }

    public static SyncReplicationActivity createEndSyncMessage(byte[] extras) {
        return new SyncReplicationActivity(ActivityID.getNextID(), EntityDescriptor.NULL_ID, ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, ActivityType.SYNC_END, extras, 0, "");
    }

    public static SyncReplicationActivity createStartEntityMessage(EntityID id, long version, byte[] configPayload, int references) {
        return new SyncReplicationActivity(ActivityID.getNextID(), SyncReplicationActivity.descriptorWithoutClient(id, version), ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, ActivityType.SYNC_ENTITY_BEGIN, configPayload, references, "");
    }

    public static SyncReplicationActivity createEndEntityMessage(EntityID id, long version) {
        return new SyncReplicationActivity(ActivityID.getNextID(), SyncReplicationActivity.descriptorWithoutClient(id, version), ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, ActivityType.SYNC_ENTITY_END, null, 0, "");
    }

    public static SyncReplicationActivity createStartEntityKeyMessage(EntityID id, long version, int concurrency) {
        Assert.assertTrue(concurrency > 0);
        return new SyncReplicationActivity(ActivityID.getNextID(), SyncReplicationActivity.descriptorWithoutClient(id, version), ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, ActivityType.SYNC_ENTITY_CONCURRENCY_BEGIN, null, concurrency, "");
    }

    public static SyncReplicationActivity createEndEntityKeyMessage(EntityID id, long version, int concurrency) {
        Assert.assertTrue(concurrency > 0);
        return new SyncReplicationActivity(ActivityID.getNextID(), SyncReplicationActivity.descriptorWithoutClient(id, version), ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, ActivityType.SYNC_ENTITY_CONCURRENCY_END, null, concurrency, "");
    }

    public static SyncReplicationActivity createPayloadMessage(EntityID id, long version, int concurrency, byte[] payload, String debugId) {
        Assert.assertTrue(concurrency > 0);
        return new SyncReplicationActivity(ActivityID.getNextID(), SyncReplicationActivity.descriptorWithoutClient(id, version), ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, ActivityType.SYNC_ENTITY_CONCURRENCY_PAYLOAD, payload, concurrency, debugId);
    }

    public static SyncReplicationActivity createStartMessage() {
        return new SyncReplicationActivity(ActivityID.getNextID(), EntityDescriptor.NULL_ID, ClientID.NULL_ID, TransactionID.NULL_ID, TransactionID.NULL_ID, ActivityType.SYNC_START, null, 0, "");
    }

    private static EntityDescriptor descriptorWithoutClient(EntityID id, long version) {
        return new EntityDescriptor(id, ClientInstanceID.NULL_ID, version);
    }

    private SyncReplicationActivity(ActivityID id, EntityDescriptor descriptor, ClientID src, TransactionID tid, TransactionID oldest, ActivityType action, byte[] payload, int concurrency, String debugId) {
        Assert.assertNotNull(id);
        Assert.assertNotNull(descriptor);
        Assert.assertNotNull(src);
        Assert.assertNotNull(tid);
        Assert.assertNotNull(oldest);
        Assert.assertNotNull((Object)action);
        this.id = id;
        this.descriptor = descriptor;
        this.src = src;
        this.tid = tid;
        this.oldest = oldest;
        this.action = action;
        this.payload = payload;
        this.concurrency = concurrency;
        this.debugId = debugId;
    }

    @Override
    public long getSequenceID() {
        return this.id.id;
    }

    public ActivityID getActivityID() {
        return this.id;
    }

    public byte[] getExtendedData() {
        return this.payload;
    }

    public ClientID getSource() {
        return this.src;
    }

    public TransactionID getTransactionID() {
        return this.tid;
    }

    public TransactionID getOldestTransactionOnClient() {
        return this.oldest;
    }

    public EntityDescriptor getEntityDescriptor() {
        return this.descriptor;
    }

    public EntityID getEntityID() {
        return this.descriptor == null ? EntityID.NULL_ID : this.descriptor.getEntityID();
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public ActivityType getActivityType() {
        return this.action;
    }

    public String getDebugID() {
        return this.debugId;
    }

    public boolean isSyncActivity() {
        return this.action.ordinal() >= ActivityType.SYNC_START.ordinal();
    }

    protected void serializeTo(TCByteBufferOutput out) {
        Assert.assertTrue(ActivityType.INVALID != this.action);
        Assert.assertTrue(ActivityType.FLUSH_LOCAL_PIPELINE != this.action);
        out.writeLong(this.id.id);
        this.descriptor.serializeTo(out);
        byte sourceNodeType = this.src.getNodeType();
        Assert.assertTrue(1 == sourceNodeType);
        out.write(sourceNodeType);
        this.src.serializeTo(out);
        out.writeLong(this.tid.toLong());
        out.writeLong(this.oldest.toLong());
        out.writeInt(this.action.ordinal());
        if (this.payload != null) {
            out.writeInt(this.payload.length);
            out.write(this.payload);
        } else {
            out.writeInt(0);
        }
        out.writeInt(this.concurrency);
        if (this.debugId == null) {
            this.debugId = "";
        }
        out.writeString(this.debugId);
    }

    public static SyncReplicationActivity deserializeFrom(TCByteBufferInput in) throws IOException {
        ActivityID activityID = new ActivityID(in.readLong());
        EntityDescriptor descriptor = EntityDescriptor.readFrom(in);
        int sourceNodeType = in.read();
        Assert.assertTrue(1 == sourceNodeType);
        ClientID source = new ClientID().deserializeFrom(in);
        TransactionID tid = new TransactionID(in.readLong());
        TransactionID oldest = new TransactionID(in.readLong());
        ActivityType action = ActivityType.values()[in.readInt()];
        int length = in.readInt();
        byte[] payload = new byte[length];
        in.readFully(payload);
        int concurrency = in.readInt();
        String debug = in.readString();
        return new SyncReplicationActivity(activityID, descriptor, source, tid, oldest, action, payload, concurrency, debug);
    }

    public String toString() {
        return "SyncReplicationActivity{activityID=" + this.id + ", entityID=" + this.descriptor.getEntityID() + ", src=" + this.src + ", tid=" + this.tid + ", oldest=" + this.oldest + ", action=" + (Object)((Object)this.action) + ", concurrency=" + this.concurrency + ", debug=" + this.debugId + '}';
    }

    public static class ActivityID {
        private static final AtomicLong NEXT_ID = new AtomicLong(1L);
        public final long id;

        public static ActivityID getNextID() {
            return new ActivityID(NEXT_ID.getAndIncrement());
        }

        public ActivityID(long id) {
            this.id = id;
        }

        public boolean equals(Object obj) {
            boolean isEqual;
            boolean bl = isEqual = this == obj;
            if (!isEqual && obj instanceof ActivityID) {
                isEqual = this.id == ((ActivityID)obj).id;
            }
            return isEqual;
        }

        public int hashCode() {
            return (int)this.id;
        }
    }

    public static enum ActivityType {
        INVALID,
        FLUSH_LOCAL_PIPELINE,
        ORDERING_PLACEHOLDER,
        CREATE_ENTITY,
        RECONFIGURE_ENTITY,
        INVOKE_ACTION,
        DESTROY_ENTITY,
        FETCH_ENTITY,
        RELEASE_ENTITY,
        SYNC_START,
        SYNC_BEGIN,
        SYNC_END,
        SYNC_ENTITY_BEGIN,
        SYNC_ENTITY_END,
        SYNC_ENTITY_CONCURRENCY_BEGIN,
        SYNC_ENTITY_CONCURRENCY_PAYLOAD,
        SYNC_ENTITY_CONCURRENCY_END;

    }
}

