/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.exception.TCInternalError;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.net.NIOWorkarounds;
import com.tc.net.core.Constants;
import com.tc.net.core.SocketParams;
import com.tc.net.core.TCChannelReader;
import com.tc.net.core.TCChannelWriter;
import com.tc.net.core.TCConnection;
import com.tc.net.core.TCConnectionImpl;
import com.tc.net.core.TCListener;
import com.tc.net.core.TCListenerImpl;
import com.tc.net.core.TCWorkerCommManager;
import com.tc.net.core.event.TCConnectionErrorEvent;
import com.tc.net.core.event.TCConnectionEvent;
import com.tc.net.core.event.TCConnectionEventListener;
import com.tc.net.core.event.TCListenerEvent;
import com.tc.net.core.event.TCListenerEventListener;
import com.tc.util.Assert;
import com.tc.util.Util;
import com.tc.util.concurrent.SetOnceFlag;
import com.tc.util.runtime.Os;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class CoreNIOServices
implements TCListenerEventListener,
TCConnectionEventListener {
    private static final TCLogger logger = TCLogging.getLogger(CoreNIOServices.class);
    private final TCWorkerCommManager workerCommMgr;
    private final String commThreadName;
    private final SocketParams socketParams;
    private final CommThread readerComm;
    private final CommThread writerComm;
    private final SetOnceFlag stopRequested = new SetOnceFlag();
    private final HashMap<TCConnection, Integer> managedConnectionsMap;
    private int clientWeights;
    private final List<TCListener> listeners = new ArrayList<TCListener>();
    private String listenerString;

    public CoreNIOServices(String commThreadName, TCWorkerCommManager workerCommManager, SocketParams socketParams) {
        this.commThreadName = commThreadName;
        this.workerCommMgr = workerCommManager;
        this.socketParams = socketParams;
        this.managedConnectionsMap = new HashMap();
        this.readerComm = new CommThread(COMM_THREAD_MODE.NIO_READER);
        this.writerComm = new CommThread(COMM_THREAD_MODE.NIO_WRITER);
    }

    public void start() {
        this.readerComm.start();
        this.writerComm.start();
    }

    public void requestStop() {
        if (this.stopRequested.attemptSet()) {
            this.readerComm.requestStop();
            this.writerComm.requestStop();
        }
    }

    public void cleanupChannel(SocketChannel channel, Runnable callback) {
        this.readerComm.cleanupChannel(channel, callback);
        this.writerComm.cleanupChannel(channel, callback);
    }

    @Override
    public void closeEvent(TCListenerEvent event) {
        this.listenerRemoved(event.getSource());
    }

    public void registerListener(TCListenerImpl lsnr, ServerSocketChannel ssc) {
        this.requestAcceptInterest(lsnr, ssc);
        this.listenerAdded(lsnr);
        lsnr.addEventListener(this);
    }

    public void stopListener(ServerSocketChannel ssc, Runnable callback) {
        this.readerComm.stopListener(ssc, callback);
    }

    private synchronized void listenerRemoved(TCListener listener) {
        boolean removed = this.listeners.remove(listener);
        Assert.eval(removed);
        this.updateListenerString();
        this.readerComm.updateThreadName();
        this.writerComm.updateThreadName();
    }

    private synchronized void listenerAdded(TCListener listener) {
        this.listeners.add(listener);
        this.updateListenerString();
        this.readerComm.updateThreadName();
        this.writerComm.updateThreadName();
    }

    private void updateListenerString() {
        if (this.listeners.isEmpty()) {
            this.listenerString = "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(" (listen ");
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            TCListener listener = this.listeners.get(i);
            buf.append(listener.getBindAddress().getHostAddress());
            buf.append(':');
            buf.append(listener.getBindPort());
            if (i >= n - 1) continue;
            buf.append(',');
        }
        buf.append(')');
        this.listenerString = buf.toString();
    }

    private synchronized String getListenerString() {
        return this.listenerString;
    }

    public long getTotalBytesRead() {
        return this.readerComm.getTotalBytesRead() + this.writerComm.getTotalBytesRead();
    }

    public long getTotalBytesWritten() {
        return this.readerComm.getTotalBytesWritten() + this.writerComm.getTotalBytesWritten();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWeight() {
        HashMap<TCConnection, Integer> hashMap = this.managedConnectionsMap;
        synchronized (hashMap) {
            return this.clientWeights;
        }
    }

    protected CommThread getReaderComm() {
        return this.readerComm;
    }

    protected CommThread getWriterComm() {
        return this.writerComm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWeight(TCConnectionImpl connection, int addWeightBy, SocketChannel channel) {
        HashMap<TCConnection, Integer> hashMap = this.managedConnectionsMap;
        synchronized (hashMap) {
            if (this.managedConnectionsMap.containsKey(connection)) {
                this.clientWeights += addWeightBy;
                this.managedConnectionsMap.put(connection, this.managedConnectionsMap.get(connection) + addWeightBy);
                return;
            }
        }
        if (this.workerCommMgr == null) {
            return;
        }
        this.readerComm.unregister(channel);
        CoreNIOServices workerComm = this.workerCommMgr.getNextWorkerComm();
        connection.setCommWorker(workerComm);
        workerComm.addConnection(connection, addWeightBy);
        workerComm.requestReadWriteInterest(connection, channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConnection(TCConnectionImpl connection, int initialWeight) {
        HashMap<TCConnection, Integer> hashMap = this.managedConnectionsMap;
        synchronized (hashMap) {
            Assert.eval(!this.managedConnectionsMap.containsKey(connection));
            this.managedConnectionsMap.put(connection, initialWeight);
            this.clientWeights += initialWeight;
            connection.addListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeEvent(TCConnectionEvent event) {
        HashMap<TCConnection, Integer> hashMap = this.managedConnectionsMap;
        synchronized (hashMap) {
            Assert.eval(this.managedConnectionsMap.containsKey(event.getSource()));
            int closedCientWeight = this.managedConnectionsMap.get(event.getSource());
            this.clientWeights -= closedCientWeight;
            this.managedConnectionsMap.remove(event.getSource());
            event.getSource().removeListener(this);
        }
    }

    @Override
    public void connectEvent(TCConnectionEvent event) {
    }

    @Override
    public void endOfFileEvent(TCConnectionEvent event) {
    }

    @Override
    public void errorEvent(TCConnectionErrorEvent errorEvent) {
    }

    public synchronized String toString() {
        return "[" + this.commThreadName + ", FD, wt:" + this.getWeight() + "]";
    }

    void requestConnectInterest(TCConnectionImpl conn, SocketChannel sc) {
        this.readerComm.requestConnectInterest(conn, sc);
    }

    private void requestAcceptInterest(TCListenerImpl lsnr, ServerSocketChannel ssc) {
        this.readerComm.requestAcceptInterest(lsnr, ssc);
    }

    void requestReadInterest(TCChannelReader reader, ScatteringByteChannel channel) {
        this.readerComm.requestReadInterest(reader, channel);
    }

    void removeReadInterest(TCConnectionImpl conn, SelectableChannel channel) {
        this.readerComm.removeReadInterest(conn, channel);
    }

    void requestWriteInterest(TCChannelWriter writer, GatheringByteChannel channel) {
        this.writerComm.requestWriteInterest(writer, channel);
    }

    void removeWriteInterest(TCConnectionImpl conn, SelectableChannel channel) {
        this.writerComm.removeWriteInterest(conn, channel);
    }

    private void requestReadWriteInterest(TCConnectionImpl conn, SocketChannel sc) {
        this.readerComm.requestReadInterest(conn, sc);
        this.writerComm.requestWriteInterest(conn, sc);
    }

    private static class NIOWorkaroundsTemp {
        private NIOWorkaroundsTemp() {
        }

        private static boolean solarisSelectWorkaround(IOException ioe) {
            String msg;
            return Os.isSolaris() && (msg = ioe.getMessage()) != null && msg.contains("Bad file number");
        }

        static /* synthetic */ boolean access$500(IOException x0) {
            return NIOWorkaroundsTemp.solarisSelectWorkaround(x0);
        }
    }

    private static class InterestRequest {
        final SelectableChannel channel;
        final Object attachment;
        final boolean set;
        final boolean add;
        final boolean remove;
        final int interestOps;
        final CommThread commNIOServiceThread;

        static InterestRequest createAddInterestRequest(SelectableChannel channel, Object attachment, int interestOps, CommThread nioServiceThread) {
            return new InterestRequest(channel, attachment, interestOps, false, true, false, nioServiceThread);
        }

        static InterestRequest createSetInterestRequest(SelectableChannel channel, Object attachment, int interestOps, CommThread nioServiceThread) {
            return new InterestRequest(channel, attachment, interestOps, true, false, false, nioServiceThread);
        }

        static InterestRequest createRemoveInterestRequest(SelectableChannel channel, Object attachment, int interestOps, CommThread nioServiceThread) {
            return new InterestRequest(channel, attachment, interestOps, false, false, true, nioServiceThread);
        }

        private InterestRequest(SelectableChannel channel, Object attachment, int interestOps, boolean set, boolean add, boolean remove, CommThread nioServiceThread) {
            Assert.eval(remove ^ set ^ add);
            Assert.eval(channel != null);
            this.channel = channel;
            this.attachment = attachment;
            this.set = set;
            this.add = add;
            this.remove = remove;
            this.interestOps = interestOps;
            this.commNIOServiceThread = nioServiceThread;
        }

        public CommThread getCommNIOServiceThread() {
            return this.commNIOServiceThread;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Interest modify request: ").append(this.channel.toString()).append("\n");
            buf.append("Ops: ").append(Constants.interestOpsToString(this.interestOps)).append("\n");
            buf.append("Set: ").append(this.set).append(", Remove: ").append(this.remove).append(", Add: ").append(this.add).append("\n");
            buf.append("Attachment: ");
            if (this.attachment != null) {
                buf.append(this.attachment.toString());
            } else {
                buf.append("null");
            }
            buf.append("\n");
            return buf.toString();
        }
    }

    protected class CommThread
    extends Thread {
        private final Selector selector;
        private final LinkedBlockingQueue<Runnable> selectorTasks;
        private final String name;
        private final AtomicLong bytesRead = new AtomicLong(0L);
        private final AtomicLong bytesWritten = new AtomicLong(0L);
        private final COMM_THREAD_MODE mode;

        public CommThread(COMM_THREAD_MODE mode) {
            this.name = CoreNIOServices.this.commThreadName + (mode == COMM_THREAD_MODE.NIO_READER ? "_R" : "_W");
            this.setDaemon(true);
            this.setName(this.name);
            this.selector = this.createSelector();
            this.selectorTasks = new LinkedBlockingQueue();
            this.mode = mode;
        }

        private boolean isReader() {
            return this.mode == COMM_THREAD_MODE.NIO_READER;
        }

        @Override
        public void run() {
            try {
                this.selectLoop();
            }
            catch (Throwable t) {
                logger.error("Unhandled exception from selectLoop", t);
                throw new RuntimeException(t);
            }
            finally {
                this.dispose(this.selector, this.selectorTasks);
            }
        }

        public void requestStop() {
            try {
                this.selector.wakeup();
            }
            catch (Exception e) {
                logger.error("Exception trying to stop " + this.getName() + ": ", e);
            }
        }

        private void updateThreadName() {
            this.setName(this.name + CoreNIOServices.this.getListenerString());
        }

        /*
         * Exception decompiling
         */
        private Selector createSelector() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addSelectorTask(Runnable task) {
            boolean isInterrupted = false;
            try {
                while (true) {
                    try {
                        this.selectorTasks.put(task);
                    }
                    catch (InterruptedException e) {
                        logger.warn(e);
                        isInterrupted = true;
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.selector.wakeup();
                Util.selfInterruptIfNeeded(isInterrupted);
            }
        }

        void unregister(final SelectableChannel channel) {
            if (Thread.currentThread() != this) {
                final CountDownLatch latch = new CountDownLatch(1);
                this.addSelectorTask(new Runnable(){

                    @Override
                    public void run() {
                        CommThread.this.unregister(channel);
                        latch.countDown();
                    }
                });
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            } else {
                SelectionKey key = null;
                key = channel.keyFor(this.selector);
                if (key != null) {
                    key.cancel();
                    key.attach(null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopListener(final ServerSocketChannel ssc, final Runnable callback) {
            if (Thread.currentThread() != this) {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        CommThread.this.stopListener(ssc, callback);
                    }
                };
                this.addSelectorTask(task);
                return;
            }
            try {
                this.cleanupChannel(ssc, null);
            }
            catch (Exception e) {
                logger.error(e);
            }
            finally {
                try {
                    callback.run();
                }
                catch (Exception e) {
                    logger.error(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanupChannel(final Channel ch, final Runnable callback) {
            if (null == ch) {
                logger.warn("null channel passed to cleanupChannel()", new Throwable());
                return;
            }
            if (Thread.currentThread() != this) {
                if (logger.isDebugEnabled()) {
                    logger.debug("queue'ing channel close operation");
                }
                this.addSelectorTask(new Runnable(){

                    @Override
                    public void run() {
                        CommThread.this.cleanupChannel(ch, callback);
                    }
                });
                return;
            }
            try {
                SelectableChannel sc;
                if (ch instanceof SelectableChannel) {
                    sc = (SelectableChannel)ch;
                    try {
                        SelectionKey sk = sc.keyFor(this.selector);
                        if (sk != null) {
                            sk.attach(null);
                            sk.cancel();
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Exception trying to clear selection key", e);
                    }
                }
                if (ch instanceof SocketChannel) {
                    sc = (SocketChannel)ch;
                    Socket s = ((SocketChannel)sc).socket();
                    if (null != s) {
                        Socket socket = s;
                        synchronized (socket) {
                            if (s.isConnected()) {
                                try {
                                    if (!s.isOutputShutdown()) {
                                        s.shutdownOutput();
                                    }
                                }
                                catch (Exception e) {
                                    logger.warn("Exception trying to shutdown socket output: " + e.getMessage());
                                }
                                try {
                                    if (!s.isClosed()) {
                                        s.close();
                                    }
                                }
                                catch (Exception e) {
                                    logger.warn("Exception trying to close() socket: " + e.getMessage());
                                }
                            }
                        }
                    }
                } else if (ch instanceof ServerSocketChannel) {
                    ServerSocketChannel ssc = (ServerSocketChannel)ch;
                    try {
                        ssc.close();
                    }
                    catch (Exception e) {
                        logger.warn("Exception trying to close() server socket" + e.getMessage());
                    }
                }
                try {
                    ch.close();
                }
                catch (Exception e) {
                    logger.warn("Exception trying to close channel", e);
                }
            }
            catch (Exception e) {
                logger.error("Unhandled exception in cleanupChannel()", e);
            }
            finally {
                try {
                    if (callback != null) {
                        callback.run();
                    }
                }
                catch (Throwable t) {
                    logger.error("Unhandled exception in cleanupChannel callback.", t);
                }
            }
        }

        private void dispose(Selector localSelector, LinkedBlockingQueue<Runnable> localSelectorTasks) {
            Assert.eval(Thread.currentThread() == this);
            if (localSelector != null) {
                for (SelectionKey key : localSelector.keys()) {
                    try {
                        this.cleanupChannel(key.channel(), null);
                    }
                    catch (Exception e) {
                        logger.warn("Exception trying to close channel", e);
                    }
                }
                try {
                    localSelector.close();
                }
                catch (Exception e) {
                    if (Os.isMac() && Os.isUnix() && e.getMessage().equals("Bad file descriptor")) {
                        logger.warn("Exception trying to close selector: " + e.getMessage());
                    }
                    logger.error("Exception trying to close selector", e);
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private void selectLoop() throws IOException {
            Assert.eval(Thread.currentThread() == this);
            localSelector = this.selector;
            localSelectorTasks = this.selectorTasks;
            block10: while (true) {
                try {
                    numKeys = localSelector.select();
                }
                catch (IOException ioe) {
                    if (NIOWorkarounds.linuxSelectWorkaround(ioe)) {
                        CoreNIOServices.access$300().warn("working around Sun bug 4504001");
                        continue;
                    }
                    if (NIOWorkaroundsTemp.access$500(ioe)) {
                        CoreNIOServices.access$300().warn("working around Solaris select IOException");
                        continue;
                    }
                    throw ioe;
                }
                catch (CancelledKeyException cke) {
                    CoreNIOServices.access$300().warn("Cencelled Key " + cke);
                    continue;
                }
                if (this.isStopRequested()) {
                    if (CoreNIOServices.access$300().isDebugEnabled()) {
                        CoreNIOServices.access$300().debug("Select loop terminating");
                    }
                    return;
                }
                isInterrupted = false;
                while (true) {
                    try {
                        task = localSelectorTasks.poll(0L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException ie) {
                        CoreNIOServices.access$300().error("Error getting task from task queue", ie);
                        isInterrupted = true;
                        continue;
                    }
                    if (null == task) break;
                    try {
                        task.run();
                    }
                    catch (Exception e) {
                        CoreNIOServices.access$300().error("error running selector task", e);
                    }
                }
                Util.selfInterruptIfNeeded(isInterrupted);
                selectedKeys = localSelector.selectedKeys();
                if (0 == numKeys && 0 == selectedKeys.size()) continue;
                iter = selectedKeys.iterator();
                while (true) {
                    if (iter.hasNext()) ** break;
                    continue block10;
                    key = iter.next();
                    iter.remove();
                    if (null == key) {
                        CoreNIOServices.access$300().error("Selection key is null");
                        continue;
                    }
                    try {
                        if (key.isAcceptable()) {
                            this.doAccept(key);
                            continue;
                        }
                        if (key.isConnectable()) {
                            this.doConnect(key);
                            continue;
                        }
                        if (this.isReader() && key.isValid() && key.isReadable()) {
                            reader = (TCChannelReader)key.attachment();
                            do {
                                read = reader.doRead();
                                this.bytesRead.addAndGet(read);
                            } while (read != 0 && key.isReadable());
                        }
                        if (key.isValid() && !this.isReader() && key.isWritable()) {
                            written = ((TCChannelWriter)key.attachment()).doWrite();
                            this.bytesWritten.addAndGet(written);
                        }
                        if ((conn = (TCConnection)key.attachment()) == null || !conn.isClosePending()) continue;
                        conn.asynchClose();
                        continue;
                    }
                    catch (CancelledKeyException cke) {
                        CoreNIOServices.access$300().info("selection key cancelled key@" + key.hashCode());
                        continue;
                    }
                    catch (Exception e) {
                        CoreNIOServices.access$300().info("Unhandled exception occured on connection layer", e);
                        conn = (TCConnectionImpl)key.attachment();
                        if (conn == null) continue;
                        conn.fireErrorEvent(new RuntimeException(e), null);
                        continue;
                    }
                    break;
                }
                break;
            }
        }

        private void doAccept(SelectionKey key) {
            SocketChannel sc = null;
            TCListenerImpl lsnr = (TCListenerImpl)key.attachment();
            try {
                ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
                sc = ssc.accept();
                if (sc == null) {
                    logger.warn("New connection accept didn't go through for " + ssc.socket());
                    return;
                }
                sc.configureBlocking(false);
                TCConnectionImpl conn = lsnr.createConnection(sc, CoreNIOServices.this, CoreNIOServices.this.socketParams);
                this.requestReadInterest(conn, sc);
            }
            catch (IOException ioe) {
                if (logger.isInfoEnabled()) {
                    logger.info("IO Exception accepting new connection", ioe);
                }
                this.cleanupChannel(sc, null);
            }
        }

        private void doConnect(SelectionKey key) {
            SocketChannel sc = (SocketChannel)key.channel();
            TCConnectionImpl conn = (TCConnectionImpl)key.attachment();
            try {
                if (sc.finishConnect()) {
                    sc.register(this.selector, 1, conn);
                    conn.finishConnect();
                } else {
                    String errMsg = "finishConnect() returned false, but no exception thrown";
                    if (logger.isInfoEnabled()) {
                        logger.info(errMsg);
                    }
                    conn.fireErrorEvent(new Exception(errMsg), null);
                }
            }
            catch (IOException ioe) {
                if (logger.isInfoEnabled()) {
                    logger.info("IOException attempting to finish socket connection", ioe);
                }
                conn.fireErrorEvent(ioe, null);
            }
        }

        public long getTotalBytesRead() {
            return this.bytesRead.get();
        }

        public long getTotalBytesWritten() {
            return this.bytesWritten.get();
        }

        private void handleRequest(final InterestRequest req) {
            if (this.isStopRequested()) {
                return;
            }
            if (Thread.currentThread() == this) {
                this.modifyInterest(req);
            } else {
                final CommThread commTh = req.getCommNIOServiceThread();
                Assert.assertNotNull(commTh);
                commTh.addSelectorTask(new Runnable(){

                    @Override
                    public void run() {
                        commTh.handleRequest(req);
                    }
                });
            }
        }

        private boolean isStopRequested() {
            return CoreNIOServices.this.stopRequested.isSet();
        }

        private void modifyInterest(InterestRequest request) {
            block10: {
                Assert.eval(Thread.currentThread() == this);
                Selector localSelector = null;
                localSelector = this.selector;
                try {
                    int existingOps;
                    SelectionKey key = request.channel.keyFor(localSelector);
                    if (key != null) {
                        if (!key.isValid()) {
                            logger.warn("Skipping modifyInterest - " + Constants.interestOpsToString(request.interestOps) + " on " + request.attachment);
                            return;
                        }
                        existingOps = key.interestOps();
                    } else {
                        existingOps = 0;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug(request);
                    }
                    if (request.add) {
                        request.channel.register(localSelector, existingOps | request.interestOps, request.attachment);
                        break block10;
                    }
                    if (request.set) {
                        request.channel.register(localSelector, request.interestOps, request.attachment);
                        break block10;
                    }
                    if (request.remove) {
                        request.channel.register(localSelector, existingOps ^ request.interestOps, request.attachment);
                        break block10;
                    }
                    throw new TCInternalError();
                }
                catch (ClosedChannelException cce) {
                    logger.warn("Exception trying to process interest request: " + cce);
                }
                catch (CancelledKeyException cke) {
                    logger.warn("Exception trying to process interest request: " + cke);
                }
            }
        }

        void requestConnectInterest(TCConnectionImpl conn, SocketChannel sc) {
            this.handleRequest(InterestRequest.createSetInterestRequest(sc, conn, 8, this));
        }

        void requestReadInterest(TCChannelReader reader, ScatteringByteChannel channel) {
            Assert.eval(this.isReader());
            this.handleRequest(InterestRequest.createAddInterestRequest((SelectableChannel)((Object)channel), reader, 1, this));
        }

        void requestWriteInterest(TCChannelWriter writer, GatheringByteChannel channel) {
            Assert.eval(!this.isReader());
            this.handleRequest(InterestRequest.createAddInterestRequest((SelectableChannel)((Object)channel), writer, 4, this));
        }

        private void requestAcceptInterest(TCListenerImpl lsnr, ServerSocketChannel ssc) {
            Assert.eval(this.isReader());
            this.handleRequest(InterestRequest.createSetInterestRequest(ssc, lsnr, 16, this));
        }

        void removeWriteInterest(TCConnectionImpl conn, SelectableChannel channel) {
            Assert.eval(!this.isReader());
            this.handleRequest(InterestRequest.createRemoveInterestRequest(channel, conn, 4, this));
        }

        void removeReadInterest(TCConnectionImpl conn, SelectableChannel channel) {
            Assert.eval(this.isReader());
            this.handleRequest(InterestRequest.createRemoveInterestRequest(channel, conn, 1, this));
        }
    }

    private static enum COMM_THREAD_MODE {
        NIO_READER,
        NIO_WRITER;

    }
}

