/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.msg;

import com.tc.async.api.OrderedEventContext;
import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.l2.msg.SyncReplicationActivity;
import com.tc.net.ClientID;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.tx.TransactionID;
import com.tc.util.Assert;
import java.io.IOException;

public class ReplicationMessage
extends AbstractGroupMessage
implements OrderedEventContext {
    public static final int INVALID = 0;
    public static final int REPLICATE = 1;
    public static final int SYNC = 2;
    public static final int START = 3;
    private SyncReplicationActivity activity;
    long rid = 0L;

    public static ReplicationMessage createStartMessage() {
        return new ReplicationMessage(3);
    }

    public static ReplicationMessage createNoOpMessage(EntityID eid, long version) {
        SyncReplicationActivity activity = SyncReplicationActivity.createNoOpMessage(eid, version);
        return new ReplicationMessage(activity);
    }

    public static ReplicationMessage createReplicatedMessage(EntityDescriptor descriptor, ClientID src, TransactionID tid, TransactionID oldest, SyncReplicationActivity.ActivityType action, byte[] payload, int concurrency, String debugId) {
        SyncReplicationActivity activity = SyncReplicationActivity.createReplicatedMessage(descriptor, src, tid, oldest, action, payload, concurrency, debugId);
        return new ReplicationMessage(activity);
    }

    public static ReplicationMessage createStartSyncMessage() {
        SyncReplicationActivity activity = SyncReplicationActivity.createStartSyncMessage();
        return new ReplicationMessage(activity);
    }

    public static ReplicationMessage createEndSyncMessage(byte[] extras) {
        SyncReplicationActivity activity = SyncReplicationActivity.createEndSyncMessage(extras);
        return new ReplicationMessage(activity);
    }

    public static ReplicationMessage createStartEntityMessage(EntityID id, long version, byte[] configPayload, int references) {
        SyncReplicationActivity activity = SyncReplicationActivity.createStartEntityMessage(id, version, configPayload, references);
        return new ReplicationMessage(activity);
    }

    public static ReplicationMessage createEndEntityMessage(EntityID id, long version) {
        SyncReplicationActivity activity = SyncReplicationActivity.createEndEntityMessage(id, version);
        return new ReplicationMessage(activity);
    }

    public static ReplicationMessage createStartEntityKeyMessage(EntityID id, long version, int concurrency) {
        Assert.assertTrue(concurrency > 0);
        SyncReplicationActivity activity = SyncReplicationActivity.createStartEntityKeyMessage(id, version, concurrency);
        return new ReplicationMessage(activity);
    }

    public static ReplicationMessage createEndEntityKeyMessage(EntityID id, long version, int concurrency) {
        Assert.assertTrue(concurrency > 0);
        SyncReplicationActivity activity = SyncReplicationActivity.createEndEntityKeyMessage(id, version, concurrency);
        return new ReplicationMessage(activity);
    }

    public static ReplicationMessage createPayloadMessage(EntityID id, long version, int concurrency, byte[] payload, String debugId) {
        Assert.assertTrue(concurrency > 0);
        SyncReplicationActivity activity = SyncReplicationActivity.createPayloadMessage(id, version, concurrency, payload, debugId);
        return new ReplicationMessage(activity);
    }

    public ReplicationMessage() {
        super(0);
    }

    protected ReplicationMessage(int type) {
        super(type);
    }

    private ReplicationMessage(SyncReplicationActivity activity) {
        super(activity.action.ordinal() >= SyncReplicationActivity.ActivityType.SYNC_BEGIN.ordinal() ? 2 : 1);
        this.activity = activity;
    }

    public void setReplicationID(long rid) {
        this.rid = rid;
    }

    @Override
    public long getSequenceID() {
        return this.rid;
    }

    public long getVersion() {
        return this.activity.descriptor.getClientSideVersion();
    }

    public SyncReplicationActivity.ActivityType getReplicationType() {
        Assert.assertNotNull(this.activity);
        return this.activity.action;
    }

    public byte[] getExtendedData() {
        return this.activity.payload;
    }

    public ClientID getSource() {
        return this.activity.src;
    }

    public TransactionID getTransactionID() {
        return this.activity.tid;
    }

    public TransactionID getOldestTransactionOnClient() {
        return this.activity.oldest;
    }

    public EntityDescriptor getEntityDescriptor() {
        return this.activity.descriptor;
    }

    public EntityID getEntityID() {
        return this.activity.descriptor == null ? EntityID.NULL_ID : this.activity.descriptor.getEntityID();
    }

    public int getConcurrency() {
        return this.activity.concurrency;
    }

    @Override
    protected void basicDeserializeFrom(TCByteBufferInput in) throws IOException {
        int messageType = this.getType();
        switch (messageType) {
            case 0: {
                Assert.fail();
                break;
            }
            case 3: {
                break;
            }
            case 1: 
            case 2: {
                this.rid = in.readLong();
                this.activity = SyncReplicationActivity.deserializeFrom(in);
                Assert.assertNotNull(this.activity);
                if (this.activity.action.ordinal() >= SyncReplicationActivity.ActivityType.SYNC_BEGIN.ordinal()) {
                    Assert.assertTrue((Object)this.activity.action, 2 == messageType);
                    break;
                }
                Assert.assertTrue((Object)this.activity.action, 1 == messageType);
            }
        }
    }

    @Override
    protected void basicSerializeTo(TCByteBufferOutput out) {
        int messageType = this.getType();
        switch (messageType) {
            case 0: {
                Assert.fail();
                break;
            }
            case 3: {
                break;
            }
            case 1: 
            case 2: {
                out.writeLong(this.rid);
                this.activity.serializeTo(out);
            }
        }
    }

    public String getDebugId() {
        return this.getType() + " " + (this.activity != null ? (this.activity.debugId.length() == 0 ? this.activity.action : this.activity.debugId) : "");
    }

    public String toString() {
        return "ReplicationMessage{rid=" + this.rid + ", activity=" + this.activity + "}";
    }
}

