/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.handler;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.ConfigurationContext;
import com.tc.logging.CustomerLogging;
import com.tc.logging.TCLogger;
import com.tc.object.ClientConfigurationContext;
import com.tc.object.context.PauseContext;
import com.tc.object.handshakemanager.ClientHandshakeManager;
import com.tc.object.msg.ClientHandshakeAckMessage;
import com.tc.object.msg.ClientHandshakeRefusedMessage;

public class ClientCoordinationHandler<EC>
extends AbstractEventHandler<EC> {
    private static final TCLogger consoleLogger = CustomerLogging.getConsoleLogger();
    private ClientHandshakeManager clientHandshakeManager;

    @Override
    public void handleEvent(EC context) {
        if (context instanceof ClientHandshakeRefusedMessage) {
            consoleLogger.error(((ClientHandshakeRefusedMessage)context).getRefusalsCause());
            consoleLogger.info("L1 Exiting...");
            throw new RuntimeException(((ClientHandshakeRefusedMessage)context).getRefusalsCause());
        }
        if (context instanceof ClientHandshakeAckMessage) {
            this.handleClientHandshakeAckMessage((ClientHandshakeAckMessage)context);
        } else if (context instanceof PauseContext) {
            this.handlePauseContext((PauseContext)context);
        } else {
            throw new AssertionError((Object)("unknown event type: " + context.getClass().getName()));
        }
    }

    private void handlePauseContext(PauseContext ctxt) {
        if (ctxt.getIsPause()) {
            this.clientHandshakeManager.disconnected();
        } else {
            this.clientHandshakeManager.connected();
        }
    }

    private void handleClientHandshakeAckMessage(ClientHandshakeAckMessage handshakeAck) {
        this.clientHandshakeManager.acknowledgeHandshake(handshakeAck);
    }

    @Override
    public synchronized void initialize(ConfigurationContext context) {
        super.initialize(context);
        ClientConfigurationContext ccContext = (ClientConfigurationContext)context;
        this.clientHandshakeManager = ccContext.getClientHandshakeManager();
    }
}

