/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.delivery;

import com.tc.net.protocol.AbstractNetworkStackHarness;
import com.tc.net.protocol.delivery.OOOConnectionWatcher;
import com.tc.net.protocol.delivery.OOOReconnectionTimeout;
import com.tc.net.protocol.delivery.OnceAndOnlyOnceProtocolNetworkLayer;
import com.tc.net.protocol.delivery.OnceAndOnlyOnceProtocolNetworkLayerFactory;
import com.tc.net.protocol.tcm.MessageChannelInternal;
import com.tc.net.protocol.tcm.ServerMessageChannelFactory;
import com.tc.net.protocol.transport.ClientConnectionEstablisher;
import com.tc.net.protocol.transport.ClientMessageTransport;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportFactory;
import com.tc.properties.ReconnectConfig;

public class OOONetworkStackHarness
extends AbstractNetworkStackHarness {
    private final OnceAndOnlyOnceProtocolNetworkLayerFactory factory;
    private OnceAndOnlyOnceProtocolNetworkLayer oooLayer;
    private final boolean isClient;
    private final ReconnectConfig reconnectConfig;

    OOONetworkStackHarness(ServerMessageChannelFactory channelFactory, MessageTransport transport, OnceAndOnlyOnceProtocolNetworkLayerFactory factory, ReconnectConfig reconnectConfig) {
        super(channelFactory, transport);
        this.isClient = false;
        this.factory = factory;
        this.reconnectConfig = reconnectConfig;
    }

    OOONetworkStackHarness(MessageTransportFactory transportFactory, MessageChannelInternal channel, OnceAndOnlyOnceProtocolNetworkLayerFactory factory, ReconnectConfig reconnectConfig) {
        super(transportFactory, channel);
        this.isClient = true;
        this.factory = factory;
        this.reconnectConfig = reconnectConfig;
    }

    @Override
    protected void connectStack() {
        this.channel.setSendLayer(this.oooLayer);
        this.oooLayer.setReceiveLayer(this.channel);
        this.oooLayer.addTransportListener(this.channel);
        this.transport.setAllowConnectionReplace(true);
        this.oooLayer.setSendLayer(this.transport);
        this.transport.setReceiveLayer(this.oooLayer);
        long timeout = 0L;
        if (this.reconnectConfig.getReconnectEnabled()) {
            timeout = this.reconnectConfig.getReconnectTimeout();
        }
        if (this.transport instanceof ClientMessageTransport) {
            ClientMessageTransport cmt = (ClientMessageTransport)this.transport;
            ClientConnectionEstablisher cce = cmt.getConnectionEstablisher();
            OOOConnectionWatcher cw = new OOOConnectionWatcher(cmt, cce, this.oooLayer, timeout);
            cmt.addTransportListener(cw);
        } else {
            OOOReconnectionTimeout ort = new OOOReconnectionTimeout(this.oooLayer, timeout);
            this.transport.addTransportListener(ort);
        }
    }

    @Override
    protected void createIntermediateLayers() {
        this.oooLayer = this.isClient ? this.factory.createNewClientInstance(this.reconnectConfig) : this.factory.createNewServerInstance(this.reconnectConfig);
    }
}

