/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import org.ehcache.clustered.client.internal.store.ClusterTierClientEntity;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.ServerStoreProxyException;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.EhcacheResponseType;
import org.ehcache.clustered.common.internal.messages.ServerStoreMessageFactory;
import org.ehcache.clustered.common.internal.store.Chain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommonServerStoreProxy
implements ServerStoreProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonServerStoreProxy.class);
    private final String cacheId;
    private final ServerStoreMessageFactory messageFactory;
    private final ClusterTierClientEntity entity;
    private final List<ServerStoreProxy.InvalidationListener> invalidationListeners = new CopyOnWriteArrayList<ServerStoreProxy.InvalidationListener>();
    private final Map<Class<? extends EhcacheEntityResponse>, ClusterTierClientEntity.ResponseListener<? extends EhcacheEntityResponse>> responseListeners = new ConcurrentHashMap<Class<? extends EhcacheEntityResponse>, ClusterTierClientEntity.ResponseListener<? extends EhcacheEntityResponse>>();

    CommonServerStoreProxy(final String cacheId, final ServerStoreMessageFactory messageFactory, final ClusterTierClientEntity entity) {
        this.cacheId = cacheId;
        this.messageFactory = messageFactory;
        this.entity = entity;
        this.responseListeners.put(EhcacheEntityResponse.ServerInvalidateHash.class, (ClusterTierClientEntity.ResponseListener<? extends EhcacheEntityResponse>)new ClusterTierClientEntity.ResponseListener<EhcacheEntityResponse.ServerInvalidateHash>(){

            @Override
            public void onResponse(EhcacheEntityResponse.ServerInvalidateHash response) {
                long key = response.getKey();
                LOGGER.debug("CLIENT: on cache {}, server requesting hash {} to be invalidated", (Object)cacheId, (Object)key);
                for (ServerStoreProxy.InvalidationListener listener : CommonServerStoreProxy.this.invalidationListeners) {
                    listener.onInvalidateHash(key);
                }
            }
        });
        this.responseListeners.put(EhcacheEntityResponse.ClientInvalidateHash.class, (ClusterTierClientEntity.ResponseListener<? extends EhcacheEntityResponse>)new ClusterTierClientEntity.ResponseListener<EhcacheEntityResponse.ClientInvalidateHash>(){

            @Override
            public void onResponse(EhcacheEntityResponse.ClientInvalidateHash response) {
                long key = response.getKey();
                int invalidationId = response.getInvalidationId();
                LOGGER.debug("CLIENT: doing work to invalidate hash {} from cache {} (ID {})", new Object[]{key, cacheId, invalidationId});
                for (ServerStoreProxy.InvalidationListener listener : CommonServerStoreProxy.this.invalidationListeners) {
                    listener.onInvalidateHash(key);
                }
                try {
                    LOGGER.debug("CLIENT: ack'ing invalidation of hash {} from cache {} (ID {})", new Object[]{key, cacheId, invalidationId});
                    entity.invokeServerStoreOperationAsync(messageFactory.clientInvalidationAck(key, invalidationId), false);
                }
                catch (Exception e) {
                    LOGGER.error("error acking client invalidation of hash {} on cache {}", new Object[]{key, cacheId, e});
                }
            }
        });
        this.responseListeners.put(EhcacheEntityResponse.ClientInvalidateAll.class, (ClusterTierClientEntity.ResponseListener<? extends EhcacheEntityResponse>)new ClusterTierClientEntity.ResponseListener<EhcacheEntityResponse.ClientInvalidateAll>(){

            @Override
            public void onResponse(EhcacheEntityResponse.ClientInvalidateAll response) {
                int invalidationId = response.getInvalidationId();
                LOGGER.debug("CLIENT: doing work to invalidate all from cache {} (ID {})", (Object)cacheId, (Object)invalidationId);
                for (ServerStoreProxy.InvalidationListener listener : CommonServerStoreProxy.this.invalidationListeners) {
                    listener.onInvalidateAll();
                }
                try {
                    LOGGER.debug("CLIENT: ack'ing invalidation of all from cache {} (ID {})", (Object)cacheId, (Object)invalidationId);
                    entity.invokeServerStoreOperationAsync(messageFactory.clientInvalidationAllAck(invalidationId), false);
                }
                catch (Exception e) {
                    LOGGER.error("error acking client invalidation of all on cache {}", (Object)cacheId, (Object)e);
                }
            }
        });
        this.addResponseListenersToEntity();
    }

    private void addResponseListenersToEntity() {
        for (Map.Entry<Class<? extends EhcacheEntityResponse>, ClusterTierClientEntity.ResponseListener<? extends EhcacheEntityResponse>> classResponseListenerEntry : this.responseListeners.entrySet()) {
            this.entity.addResponseListener(classResponseListenerEntry.getKey(), classResponseListenerEntry.getValue());
        }
    }

    @Override
    public String getCacheId() {
        return this.cacheId;
    }

    @Override
    public void addInvalidationListener(ServerStoreProxy.InvalidationListener listener) {
        this.invalidationListeners.add(listener);
    }

    @Override
    public boolean removeInvalidationListener(ServerStoreProxy.InvalidationListener listener) {
        return this.invalidationListeners.remove(listener);
    }

    <T extends EhcacheEntityResponse> void addResponseListeners(Class<T> listenerClass, ClusterTierClientEntity.ResponseListener<T> listener) {
        this.responseListeners.put(listenerClass, listener);
        this.entity.addResponseListener(listenerClass, listener);
    }

    @Override
    public void close() {
        this.entity.close();
    }

    @Override
    public Chain get(long key) throws TimeoutException {
        EhcacheEntityResponse response;
        try {
            response = this.entity.invokeServerStoreOperation(this.messageFactory.getOperation(key), false);
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
        if (response != null && response.getResponseType() == EhcacheResponseType.GET_RESPONSE) {
            return ((EhcacheEntityResponse.GetResponse)response).getChain();
        }
        throw new ServerStoreProxyException("Response for get operation was invalid : " + (response != null ? response.getResponseType() : "null message"));
    }

    @Override
    public void append(long key, ByteBuffer payLoad) throws TimeoutException {
        try {
            this.entity.invokeServerStoreOperation(this.messageFactory.appendOperation(key, payLoad), true);
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
    }

    @Override
    public Chain getAndAppend(long key, ByteBuffer payLoad) throws TimeoutException {
        EhcacheEntityResponse response;
        try {
            response = this.entity.invokeServerStoreOperation(this.messageFactory.getAndAppendOperation(key, payLoad), true);
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
        if (response != null && response.getResponseType() == EhcacheResponseType.GET_RESPONSE) {
            return ((EhcacheEntityResponse.GetResponse)response).getChain();
        }
        throw new ServerStoreProxyException("Response for getAndAppend operation was invalid : " + (response != null ? response.getResponseType() : "null message"));
    }

    @Override
    public void replaceAtHead(long key, Chain expect, Chain update) {
        try {
            this.entity.invokeServerStoreOperationAsync(this.messageFactory.replaceAtHeadOperation(key, expect, update), true);
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
    }

    @Override
    public void clear() throws TimeoutException {
        try {
            this.entity.invokeServerStoreOperation(this.messageFactory.clearOperation(), true);
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServerStoreProxyException(e);
        }
    }
}

