/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.ehcache.clustered.client.internal.service.ClusteredMapException;
import org.ehcache.clustered.client.internal.store.ClusterTierClientEntity;
import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityResponse;
import org.ehcache.clustered.common.internal.messages.StateRepositoryMessageFactory;
import org.ehcache.clustered.common.internal.messages.StateRepositoryOpMessage;
import org.ehcache.spi.persistence.StateHolder;

public class ClusteredStateHolder<K, V>
implements StateHolder<K, V> {
    private final StateRepositoryMessageFactory messageFactory;
    private final ClusterTierClientEntity entity;

    public ClusteredStateHolder(String cacheId, String mapId, ClusterTierClientEntity entity) {
        this.messageFactory = new StateRepositoryMessageFactory(cacheId, mapId, entity.getClientId());
        this.entity = entity;
    }

    public V get(Object key) {
        return (V)this.getResponse(this.messageFactory.getMessage(key));
    }

    private Object getResponse(StateRepositoryOpMessage message) {
        try {
            EhcacheEntityResponse response = this.entity.invokeStateRepositoryOperation(message);
            return ((EhcacheEntityResponse.MapValue)response).getValue();
        }
        catch (ClusterException ce) {
            throw new ClusteredMapException(ce);
        }
        catch (TimeoutException te) {
            throw new ClusteredMapException(te);
        }
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return (Set)this.getResponse(this.messageFactory.entrySetMessage());
    }

    public V putIfAbsent(K key, V value) {
        return (V)this.getResponse(this.messageFactory.putIfAbsentMessage(key, value));
    }
}

