/*
 * Decompiled with CFR 0.152.
 */
package com.tc.security;

import com.tc.security.PwProvider;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;

public class PwProviderUtil {
    private static AtomicReference<PwProvider> backend = new AtomicReference();

    public static char[] getPasswordTo(URI uri) {
        PwProvider tcSecurityManager = backend.get();
        if (tcSecurityManager == null) {
            throw new IllegalStateException("We haven't had a BackEnd set yet!");
        }
        return tcSecurityManager.getPasswordFor(uri);
    }

    public static void setBackEnd(PwProvider securityManager) {
        if (!backend.compareAndSet(null, securityManager)) {
            throw new IllegalStateException("BackEnd was already set!");
        }
    }

    public static PwProvider getProvider() {
        return backend.get();
    }
}

