/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.locks;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import com.tc.object.locks.EntityLockID;
import com.tc.object.locks.LockID;
import com.tc.object.locks.LongLockID;
import com.tc.object.locks.StringLockID;
import java.io.IOException;

public class LockIDSerializer
implements TCSerializable<LockIDSerializer> {
    private static final LockID.LockIDType[] LOCK_ID_TYPE_VALUES = LockID.LockIDType.values();
    private LockID lockID;

    public LockIDSerializer() {
    }

    public LockIDSerializer(LockID lockID) {
        this.lockID = lockID;
    }

    public LockID getLockID() {
        return this.lockID;
    }

    @Override
    public LockIDSerializer deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        byte type = serialInput.readByte();
        LockID tempLockID = this.getImpl(type);
        this.lockID = (LockID)tempLockID.deserializeFrom(serialInput);
        return this;
    }

    private LockID getImpl(byte type) {
        try {
            switch (LOCK_ID_TYPE_VALUES[type]) {
                case LONG: {
                    return new LongLockID();
                }
                case STRING: {
                    return new StringLockID();
                }
                case ENTITY: {
                    return new EntityLockID();
                }
            }
            throw new AssertionError((Object)("Unknown type : " + type));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new AssertionError((Object)("Unknown type : " + type));
        }
    }

    @Override
    public void serializeTo(TCByteBufferOutput serialOutput) {
        serialOutput.writeByte((byte)this.lockID.getLockType().ordinal());
        this.lockID.serializeTo(serialOutput);
    }
}

