/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.utils;

import java.nio.ByteBuffer;
import org.terracotta.runnel.utils.ReadBuffer;

public class VLQ {
    public static void encode(int value, ByteBuffer out) {
        if (value < 0) {
            throw new IllegalArgumentException("Cannot encode negative values");
        }
        boolean msbFound = false;
        int b = (value & 0x70000000) >> 28;
        if (b != 0) {
            out.put((byte)(b | 0x80));
            msbFound = true;
        }
        b = (value & 0xFE00000) >> 21;
        if (msbFound || b != 0) {
            out.put((byte)(b | 0x80));
            msbFound = true;
        }
        b = (value & 0x1FC000) >> 14;
        if (msbFound || b != 0) {
            out.put((byte)(b | 0x80));
            msbFound = true;
        }
        b = (value & 0x3F80) >> 7;
        if (msbFound || b != 0) {
            out.put((byte)(b | 0x80));
        }
        b = value & 0x7F;
        out.put((byte)b);
    }

    public static int decode(ReadBuffer in) {
        int value = 0;
        for (int i = 0; i < 5; ++i) {
            byte b = in.getByte();
            value |= b & 0x7F;
            if ((b & 0x80) == 0) {
                return value;
            }
            value <<= 7;
        }
        throw new IllegalArgumentException("Cannot decode value greater than Integer.MAX_VALUE");
    }

    public static int encodedSize(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Cannot encode negative values");
        }
        int i = 1;
        while ((long)(value & 0xFFFFFF80) != 0L) {
            value >>>= 7;
            ++i;
        }
        return i;
    }
}

