/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.io.Serializable;
import java.util.UUID;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.clustered.common.internal.ServerStoreConfiguration;
import org.ehcache.clustered.common.internal.messages.EhcacheMessageType;
import org.ehcache.clustered.common.internal.messages.EhcacheOperationMessage;

public abstract class LifecycleMessage
extends EhcacheOperationMessage
implements Serializable {
    protected UUID clientId;
    protected long id = -1L;

    @Override
    public UUID getClientId() {
        if (this.clientId == null) {
            throw new AssertionError((Object)"Client Id cannot be null for lifecycle messages");
        }
        return this.clientId;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public static class PrepareForDestroy
    extends LifecycleMessage {
        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.PREPARE_FOR_DESTROY;
        }
    }

    public static class ValidateServerStore
    extends BaseServerStore {
        private static final long serialVersionUID = 8762670006846832185L;

        ValidateServerStore(String name, ServerStoreConfiguration storeConfiguration, UUID clientId) {
            super(name, storeConfiguration, clientId);
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.VALIDATE_SERVER_STORE;
        }
    }

    public static abstract class BaseServerStore
    extends LifecycleMessage {
        private static final long serialVersionUID = 4879477027919589726L;
        private final String name;
        private final ServerStoreConfiguration storeConfiguration;

        BaseServerStore(String name, ServerStoreConfiguration storeConfiguration, UUID clientId) {
            this.name = name;
            this.storeConfiguration = storeConfiguration;
            this.clientId = clientId;
        }

        public String getName() {
            return this.name;
        }

        public ServerStoreConfiguration getStoreConfiguration() {
            return this.storeConfiguration;
        }
    }

    public static class ValidateStoreManager
    extends LifecycleMessage {
        private static final long serialVersionUID = 5742152283115139745L;
        private final ServerSideConfiguration configuration;

        ValidateStoreManager(ServerSideConfiguration config, UUID clientId) {
            this.configuration = config;
            this.clientId = clientId;
        }

        @Override
        public EhcacheMessageType getMessageType() {
            return EhcacheMessageType.VALIDATE;
        }

        public ServerSideConfiguration getConfiguration() {
            return this.configuration;
        }
    }
}

