/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.dna.impl;

import com.tc.object.dna.impl.BaseDNAEncodingImpl;
import com.tc.object.dna.impl.UTF8ByteDataHolder;
import java.util.Arrays;

public class UTF8ByteCompressedDataHolder
extends UTF8ByteDataHolder {
    private static final int HASH_SEED = -1597117597;
    private final int uncompressedLength;
    private final int originalStringLength;
    private final int originalStringHash;

    public UTF8ByteCompressedDataHolder(byte[] b, int uncompressedLength, int originalStringLength, int originalStringHash) {
        super(b);
        this.uncompressedLength = uncompressedLength;
        this.originalStringLength = originalStringLength;
        this.originalStringHash = originalStringHash;
    }

    private String inflate() {
        return BaseDNAEncodingImpl.inflateCompressedString(this.getBytes(), this.uncompressedLength);
    }

    @Override
    public String asString() {
        return this.inflate();
    }

    @Override
    public int hashCode() {
        return this.computeHashCode(-1597117597);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof UTF8ByteCompressedDataHolder) {
            UTF8ByteCompressedDataHolder other = (UTF8ByteCompressedDataHolder)obj;
            return this.uncompressedLength == other.uncompressedLength && Arrays.equals(this.getBytes(), other.getBytes());
        }
        return false;
    }

    public boolean isCompressed() {
        return this.uncompressedLength != -1;
    }

    public int getUncompressedStringLength() {
        return this.uncompressedLength;
    }

    public int getStringLength() {
        return this.originalStringLength;
    }

    public int getStringHash() {
        return this.originalStringHash;
    }
}

