/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.encoding;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.terracotta.runnel.decoding.fields.BoolField;
import org.terracotta.runnel.decoding.fields.ByteBufferField;
import org.terracotta.runnel.decoding.fields.CharField;
import org.terracotta.runnel.decoding.fields.EnumField;
import org.terracotta.runnel.decoding.fields.FloatingPoint64Field;
import org.terracotta.runnel.decoding.fields.Int32Field;
import org.terracotta.runnel.decoding.fields.Int64Field;
import org.terracotta.runnel.decoding.fields.StringField;
import org.terracotta.runnel.decoding.fields.StructField;
import org.terracotta.runnel.encoding.PrimitiveEncodingSupport;
import org.terracotta.runnel.encoding.StructEncoder;
import org.terracotta.runnel.encoding.dataholders.BoolDataHolder;
import org.terracotta.runnel.encoding.dataholders.ByteBufferDataHolder;
import org.terracotta.runnel.encoding.dataholders.CharDataHolder;
import org.terracotta.runnel.encoding.dataholders.DataHolder;
import org.terracotta.runnel.encoding.dataholders.EnumDataHolder;
import org.terracotta.runnel.encoding.dataholders.FloatingPoint64DataHolder;
import org.terracotta.runnel.encoding.dataholders.Int32DataHolder;
import org.terracotta.runnel.encoding.dataholders.Int64DataHolder;
import org.terracotta.runnel.encoding.dataholders.StringDataHolder;
import org.terracotta.runnel.encoding.dataholders.StructDataHolder;
import org.terracotta.runnel.metadata.FieldSearcher;

public class StructArrayEncoder<P>
implements PrimitiveEncodingSupport<StructArrayEncoder> {
    private static final int ARRAY_INITIAL_SIZE = 16;
    private final List<StructDataHolder> values;
    private final P parent;
    private final FieldSearcher fieldSearcher;
    private List<DataHolder> currentData;

    StructArrayEncoder(List<StructDataHolder> values, P parent, StructField structField) {
        this.values = values;
        this.parent = parent;
        this.fieldSearcher = structField.getMetadata().fieldSearcher();
        this.currentData = new ArrayList<DataHolder>(16);
    }

    @Override
    public StructArrayEncoder<P> bool(String name, boolean value) {
        BoolField field = this.fieldSearcher.findField(name, BoolField.class, null);
        this.currentData.add(new BoolDataHolder(value, field.index()));
        return this;
    }

    @Override
    public StructArrayEncoder<P> chr(String name, char value) {
        CharField field = this.fieldSearcher.findField(name, CharField.class, null);
        this.currentData.add(new CharDataHolder(value, field.index()));
        return this;
    }

    @Override
    public <E> StructArrayEncoder<P> enm(String name, E value) {
        EnumField field = this.fieldSearcher.findField(name, EnumField.class, null);
        this.currentData.add(new EnumDataHolder<E>(value, field.index(), field.getEnumMapping()));
        return this;
    }

    @Override
    public StructArrayEncoder<P> int32(String name, int value) {
        Int32Field field = this.fieldSearcher.findField(name, Int32Field.class, null);
        this.currentData.add(new Int32DataHolder(value, field.index()));
        return this;
    }

    @Override
    public StructArrayEncoder<P> int64(String name, long value) {
        Int64Field field = this.fieldSearcher.findField(name, Int64Field.class, null);
        this.currentData.add(new Int64DataHolder(value, field.index()));
        return this;
    }

    @Override
    public StructArrayEncoder<P> fp64(String name, double value) {
        FloatingPoint64Field field = this.fieldSearcher.findField(name, FloatingPoint64Field.class, null);
        this.currentData.add(new FloatingPoint64DataHolder(value, field.index()));
        return this;
    }

    @Override
    public StructArrayEncoder<P> string(String name, String value) {
        StringField field = this.fieldSearcher.findField(name, StringField.class, null);
        this.currentData.add(new StringDataHolder(value, field.index()));
        return this;
    }

    @Override
    public StructArrayEncoder<P> byteBuffer(String name, ByteBuffer value) {
        ByteBufferField field = this.fieldSearcher.findField(name, ByteBufferField.class, null);
        this.currentData.add(new ByteBufferDataHolder(value, field.index()));
        return this;
    }

    public StructEncoder<StructArrayEncoder<P>> struct(String name) {
        StructField field = this.fieldSearcher.findField(name, StructField.class, null);
        ArrayList<DataHolder> values = new ArrayList<DataHolder>();
        this.currentData.add(new StructDataHolder(values, field.index()));
        return new StructEncoder<StructArrayEncoder<P>>(field, values, this);
    }

    public StructArrayEncoder<P> next() {
        this.fieldSearcher.reset();
        this.values.add(new StructDataHolder(this.currentData, -1));
        this.currentData = new ArrayList<DataHolder>(16);
        return this;
    }

    public P end() {
        if (!this.currentData.isEmpty()) {
            this.values.add(new StructDataHolder(this.currentData, -1));
        }
        return this.parent;
    }
}

