/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.logging.TCLogger;
import com.tc.net.core.TCConnection;
import com.tc.net.protocol.AbstractTCNetworkHeader;
import com.tc.net.protocol.TCNetworkHeader;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.TCProtocolAdaptor;
import com.tc.net.protocol.TCProtocolException;
import com.tc.util.Assert;

public abstract class AbstractTCProtocolAdaptor
implements TCProtocolAdaptor {
    protected static final int MODE_HEADER = 1;
    protected static final int MODE_DATA = 2;
    private final TCLogger logger;
    private int dataBytesNeeded;
    private AbstractTCNetworkHeader header;
    private TCByteBuffer[] dataBuffers;
    private int bufferIndex = -1;
    private int mode;

    public AbstractTCProtocolAdaptor(TCLogger logger) {
        this.logger = logger;
        this.init();
    }

    @Override
    public void addReadData(TCConnection source, TCByteBuffer[] data, int length) throws TCProtocolException {
        this.processIncomingData(source, data, length);
    }

    @Override
    public final TCByteBuffer[] getReadBuffers() {
        if (this.mode == 1) {
            return new TCByteBuffer[]{this.header.getDataBuffer()};
        }
        Assert.eval(this.mode == 2);
        if (this.dataBuffers == null) {
            this.dataBuffers = this.createDataBuffers(this.dataBytesNeeded);
            Assert.eval(this.dataBuffers.length > 0);
            this.bufferIndex = 0;
        }
        TCByteBuffer[] rv = new TCByteBuffer[this.dataBuffers.length - this.bufferIndex];
        System.arraycopy(this.dataBuffers, this.bufferIndex, rv, 0, rv.length);
        boolean spaceAvail = false;
        int n = rv.length;
        for (int i = 0; i < n; ++i) {
            if (!rv[i].hasRemaining()) continue;
            spaceAvail = true;
            break;
        }
        Assert.assertTrue("No space in buffers to read more data", spaceAvail);
        return rv;
    }

    protected abstract AbstractTCNetworkHeader getNewProtocolHeader();

    protected abstract TCNetworkMessage createMessage(TCConnection var1, TCNetworkHeader var2, TCByteBuffer[] var3) throws TCProtocolException;

    protected abstract int computeDataLength(TCNetworkHeader var1);

    protected final void init() {
        this.mode = 1;
        this.dataBuffers = null;
        this.header = this.getNewProtocolHeader();
    }

    protected final TCNetworkMessage processIncomingData(TCConnection source, TCByteBuffer[] data, int length) throws TCProtocolException {
        if (this.mode == 1) {
            return this.processHeaderData(source, data);
        }
        Assert.eval(this.mode == 2);
        if (length > this.dataBytesNeeded) {
            throw new TCProtocolException("More data read then expected: (" + length + " > " + this.dataBytesNeeded + ")");
        }
        return this.processPayloadData(source, data);
    }

    protected final TCLogger getLogger() {
        return this.logger;
    }

    private TCByteBuffer[] createDataBuffers(int length) {
        Assert.eval(this.mode == 2);
        return TCByteBufferFactory.getFixedSizedInstancesForLength(false, length);
    }

    private TCNetworkMessage processHeaderData(TCConnection source, TCByteBuffer[] data) throws TCProtocolException {
        Assert.eval(data.length == 1);
        Assert.eval(data[0] == this.header.getDataBuffer());
        if (!this.header.isHeaderLengthAvail()) {
            return null;
        }
        TCByteBuffer buf = data[0];
        int headerLength = this.header.getHeaderByteLength();
        int bufferLength = buf.limit();
        if (headerLength == -1) {
            return null;
        }
        if (headerLength < this.header.minLength || headerLength > this.header.maxLength || headerLength < bufferLength) {
            throw new TCProtocolException("Invalid Header Length: " + headerLength + ", min: " + this.header.minLength + ", max: " + this.header.maxLength + ", bufLen: " + bufferLength);
        }
        if (bufferLength != headerLength) {
            buf.limit(headerLength);
            return null;
        }
        Assert.eval(bufferLength == headerLength);
        if (buf.position() == headerLength) {
            this.header.validate();
            this.mode = 2;
            this.dataBytesNeeded = this.computeDataLength(this.header);
            this.dataBuffers = null;
            if (this.dataBytesNeeded < 0) {
                throw new TCProtocolException("Negative data size detected: " + this.dataBytesNeeded);
            }
            if (0 == this.dataBytesNeeded) {
                return this.createMessage(source, this.header, null);
            }
            return null;
        }
        return null;
    }

    private TCNetworkMessage processPayloadData(TCConnection source, TCByteBuffer[] data) throws TCProtocolException {
        TCByteBuffer buffer;
        for (int i = 0; i < data.length && !(buffer = data[i]).hasRemaining(); ++i) {
            buffer.flip();
            this.dataBytesNeeded -= buffer.limit();
            ++this.bufferIndex;
            if (this.dataBytesNeeded >= 0) continue;
            throw new TCProtocolException("More data in buffers than expected");
        }
        if (0 == this.dataBytesNeeded) {
            if (this.bufferIndex != this.dataBuffers.length) {
                throw new TCProtocolException("Not all buffers consumed");
            }
            TCNetworkMessage msg = this.createMessage(source, this.header, this.dataBuffers);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Message complete on connection " + source + ": " + msg.toString());
            }
            return msg;
        }
        Assert.eval(this.dataBytesNeeded > 0);
        return null;
    }
}

