/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.ehcache.clustered.common.internal.messages.EhcacheEntityMessage;
import org.ehcache.clustered.common.internal.messages.ServerStoreOpMessage;
import org.ehcache.clustered.common.internal.store.Chain;

public class ServerStoreMessageFactory {
    private final String cacheId;
    private final UUID clientId;

    public ServerStoreMessageFactory(String cacheId, UUID clientId) {
        this.cacheId = cacheId;
        this.clientId = clientId;
    }

    public EhcacheEntityMessage getOperation(long key) {
        return new ServerStoreOpMessage.GetMessage(this.cacheId, key);
    }

    public EhcacheEntityMessage getAndAppendOperation(long key, ByteBuffer payload) {
        return new ServerStoreOpMessage.GetAndAppendMessage(this.cacheId, key, payload, this.clientId);
    }

    public EhcacheEntityMessage appendOperation(long key, ByteBuffer payload) {
        return new ServerStoreOpMessage.AppendMessage(this.cacheId, key, payload, this.clientId);
    }

    public EhcacheEntityMessage replaceAtHeadOperation(long key, Chain expect, Chain update) {
        return new ServerStoreOpMessage.ReplaceAtHeadMessage(this.cacheId, key, expect, update, this.clientId);
    }

    public EhcacheEntityMessage clientInvalidationAck(int invalidationId) {
        return new ServerStoreOpMessage.ClientInvalidationAck(this.cacheId, invalidationId);
    }

    public EhcacheEntityMessage clearOperation() {
        return new ServerStoreOpMessage.ClearMessage(this.cacheId, this.clientId);
    }

    public String getCacheId() {
        return this.cacheId;
    }
}

